/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIListener;

/** 
 * An instance implementing ReaderListener is used by an Applet
 * to monitor the ReaderService.
  **/

public interface ReaderListener extends HCIListener {

	/** 
	 * This value is used to notify the Applet when a response to the 
     * {@link ReaderMessage#prepareAndSendGetParameterCommmand(byte)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
	 */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

	/** 
	 * This value is used to notify the Applet when a response to the 
     * {@link ReaderMessage#prepareWriteXchgDataCommand(byte, byte[], short, short)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
	 */
    public final static byte EVENT_WRITE_EXCHANGE_DATA_RESPONSE = (byte) 0x02;

	/** 
	 * This value is used to notify the Applet when the HCI event EVT_TARGET_DISCOVERD
	 * as received from the CLF. 
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_TARGET_DISCOVERED = (byte) 0x50;



    /**    
 	 * This method is called by the HCI framework in 3 situations:
     * 1. A predefined condition (see HCIService.activateEvent()) is fulfilled. 
     * 
     * 2. A certain return value on a previous invocation of this method was returned. 
     * 
     * 3. When a previous call to the method HCIService.requestCallBackNotification()
     * from the same Applet was made.
     * 
     * (editor's note: 
     *  1. align all methods with the word fragment 'triggering'.
     *  2. improve wording )
     *
     * 
     * @param  event the condition caused this invocation of onCallBack()
     * @param message the HCIMessage
     * @return condition for next invocation:
     * <ul>
     * <li>{@link uicc.hci.framework.HCIListener#TRIG_NO_MORE_PROCESS}: the listener does
     *  not request to be called back
     * <li> value greater than 0: The listener request to be call back as soon
     * as possible with the given triggering condition. The specific values are 
     * listed in the documentation of the sub interfaces.
     * <li> value less than  0: forbidden (will be ignored).
     * </ul>     
     */
    public byte onCallBack(byte event, ReaderMessage message);
}