/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

/**
 * An instance of HCIMessage is used to get access to the content of a received 
 * HCI message.
 * Fragmentation is handeled on the framework level ? ,
 * receiveBuffer is min. 270 bytes long ?
 *
 * <P>Sub interfaces will typically have additional methods for sending HCI service
 * specific HCI messages.
 * <P>Instances of HCIMessage hide the fragmentation of messages on the HCI layer
 * (see TS 102 622). However, as receive and send buffers with limited capacity will
 * be used (size depends on the Applet itself) it provides methods to check if
 * a message is complete (see <code>isHeading()</code> and <code>isComplete()</code>) in order to support
 * streaming of long messages. 
 * (editors note: move statements about buffer sizes from getReceiveBuffer()to the previous
 * paragraph.)
 * (editor's note: check what the following sentence means:) in order to chain 
 * multiple trigger session
 * the Applet will need to use applicative callback for consume or produce
 * the message.
 * <span style="color:red">
 * <P>Notes:
 * <ul>
 *
 * <li>Instances of this object shall be temporary JCRE entry point objects.
 * <li> The HCI framework provides a shared volatile array in order to limit application
 * memory needs. see {@link HCIMessage#getReceiveBuffer() }
 * </ul>
 * </span>
 * @see uicc.hci.framework.HCIListener
 **/
public interface HCIMessage {

	/* (editor's note: some/most?) of the following contants are not needed and shall
	*		be deleted, todo sha).
	**/
    // ---------  Message types -------------
    /** a command */
    public static final byte TYPE_COMMAND = (byte) 0x00;
    
    /** an event */
    public static final byte TYPE_EVENT = (byte) 0x40;
    
    /** a response*/
    public static final byte TYPE_RESPONSE = (byte) 0x80;

    // --------- All Gate Message instructions -------------
    /** The command to set a parameter in a registry */
    public static final byte INS_ANY_SET_PARAMETER = (byte) 0x01;
    
    /** The command to get a parameter from a registry */
    public static final byte INS_ANY_GET_PARAMETER = (byte) 0x02;
    
    /** The command to open a pipe */
    public static final byte INS_ANY_OPEN_PIPE = (byte) 0x03;
    
    /** The command to close a pipe */
    public static final byte INS_ANY_CLOSE_PIPE = (byte) 0x04;

    // --------- All Gate Message response -------------
    /** command completed successfully (with optional parameters)*/
    public static final byte RESP_ANY_OK = (byte) 0x00;
    
    /** the destination host is not connected*/
    public static final byte RESP_ANY_E_NOT_CONNECTED = (byte) 0x01;
    
    /** the format of the command parameters is wrong*/
    public static final byte RESP_ANY_E_CMD_PAR_UNKNOWN = (byte) 0x02;
    
    /** command was rejected and/or not completed */
    public static final byte RESP_ANY_E_NOK = (byte) 0x03;
    
    /** no more dynamic pipes can be created */
    public static final byte RESP_ADM_E_NO_PIPES_AVAILABLE = (byte) 0x04;
    
    /** the registry parameter identifier is either unknown to the registry or an optional registry parameter is not implemented*/
    public static final byte RESP_ANY_E_REG_PAR_UNKNOWN = (byte) 0x05;
    
    /** the pipe is not open */
    public static final byte RESP_ANY_E_PIPE_NOT_OPENED = (byte) 0x06;
    
    /** the command is not supported by the gate*/
    public static final byte RESP_ANY_E_CMD_NOT_SUPPORTED = (byte) 0x07;
    
    /** command is inhibited due to failure of lower layer identity check*/
    public static final byte RESP_ANY_E_INHIBITED = (byte) 0x08;
    
    /** permission denied to write/read a value to/from a registry */
    public static final byte RESP_ANY_E_REG_ACCESS_DENIED = (byte) 0x0A;
    
    /** Permission denied to create a pipe due to a WHITELIST violation*/
    public static final byte RESP_ANY_E_PIPE_ACCESS_DENIED = (byte) 0x0B;

    /**
     * editor's note: check if 'heading' is the correct term.
     */
    /** 
     * Checks if this is the heading part of an HCI message
     * 
     * The heading information indicates the first part of an HCI message with 
     * <code>isComplete()</code> it is possible to check weather the complete message
     * has already been received.
     *
     * <P>The preparing of an outgoing message (command response or event)
     * will reset the current HCI message states according the outgoing message.
     *
     * @return true if the current message is the heading part of the message
     * e.g the first part of an incoming message.
     **/
    @remove
    public boolean isHeading();

    /** 
     * Cheks for the completnes of the HCI message.
     *
     * <P>The preparing of an outgoing message (command response or event)
     * will reset the current HCI message states according the outgoing message.
     *
     * @return true if the message is complete
     **/
    @remove
    public boolean isComplete();

    /**
     * Checks the type of the incomming HCI message
     * 
     * <span style="color:red">editor's note: check if this method is still needed.</span>
     * 
     * <span style="color:red"> Does this statement provide any value</span> 
     * <P>Please note that in the case of a fragmented incoming message the type
     * is keep in memory even if the data processed is no more in the first heading
     * packet.
     * @return return the message type, must be one of constant values <code>TYPE_*</code> defined in this interface
     **/
    public byte getType();

    /** 
     * <span style="color:red">editor's note: check if needed and reword or delete accordingly).</span>
     * Returns the message instruction (b6-b1 of the message header) from the current 
     * incomming HCI message, see TS 102 622 for further information.
     * 
     *
     * <span style="color:red"> Does this statement provide any value</span>
     * <P>In the case of a fragmented incoming message the instruction
     * is kept in memory even if the data processed is no more in the first heading
     * packet.
     * </span>
     *  <P>The preparing of an outgoing message (command response or event)
     *     will reset the current HCI message states and set them according the
     *     outgoing message.
     *
     * @return return the message instruction, must be one of constant values <code>INS_*</code> defined in this interface
     **/
    public byte getInstruction();

    /** 
     * Return a refernce to the underlying HCI message receive buffer. The length of this
     * buffer is system dependend. The framework implementation shall guarantee a buffer size
     * to receive a message of min. 270 bytes.
     *
     * <P>When the listener is triggered with an incoming message the usable data
     * shall be found in the buffer returned by this method, starting at the offset gven by
     * the method <code>getReceiveOffset()</code>. The length of the received message or message fragment
     * can be retrieved from <code>getReceiveLength()</code>.
     * 
     * <ul>
     * <li>The framework shall copy data into the receive buffer up to the end of the buffer.
     * When the HCIMessage is longer then the available buffer length the HCIMessage shall be set
     * as not complete.
     * 
     * <li> The application may use the whole receive buffer for
     * its internal purposes. If the buffer is used for manipulation of sensitive
     * data it shall be cleared by the Applet before returning to the JCRE.
     *
     * <span style="color:red"> Editor: This has to be clarified we switch between invocation and triggering we
     *                          need have to agree on a consistent wording
     * <li>The content of this array is not guaranteed between several invocations
     *
     * <li> The content of the buffer is not cleared between triggering session
     * (even before triggering an other Applet) if the buffer is used for
     * manipulation of sensitive data it shall be cleared by the Applet before
     * returning to the JCRE.  
     * </ul>
     * </span>
     * @return the buffer holding the current HCI message.
     **/
    public byte[] getReceiveBuffer();

    /** 
     * This method gives the offset to the received message data in the receive buffer.
     * @return the offset into the buffer, retrieved via <code>getReceiveBuffer()</code>.
     **/
    public short getReceiveOffset();

    /**
     * This method gives the length of the received message data.<span style="color:red"> Editor: is this length that is received or that is copied into the buffer?</span> If the message is
     * not complete then the returned value is the actual message fragment length.
     * 
     * @return the message data length available in the receive buffer.
     **/
    public short getReceiveLength();
}
