package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIListener;

/**
 * An Applet instance implementing the  <code>CardEmulationListener</code> interface can
 * receive events defined in this interface and can receive only  <code>CardEmulationMessagee</code>.
 *
 * An Applet implementing this Listener Interface shall onyl receive the events
 * defined in this interface.
 *  The Applet instance has to activate the events in the
 *  <code>CardEmulationService</code> before it will recive any event notification.
 * 
 * @see CardEmulationService
 * @see CardEmulationMessage
 **/
public interface CardEmulationListener extends HCIListener {

    /** This value is used to notify the Applet when a response to the 
     * {@link CardEmulationMessage#prepareAndSendGetParameterCommmand(byte)}
     * is received.
     *
     */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /** This value is used to notify the Applet when the HCI event EVT_SEND_DATA
     * is received.
     */
    public final static byte EVENT_ON_SEND_DATA = (byte) 0x50;

    /** This value is used to notify the Applet when the HCI event EVT_FIELD_OFF
     * is received
     */
    public final static byte EVENT_FIELD_OFF = (byte) 0x54;
}

