package uicc.scws;

import javacard.framework.Shareable;

/**
 * Interface which specifies all methods used to pass information included in a HTTP request to
 * the registered application.
 */
public interface ScwsExtension extends Shareable
{

    /**
     * Invoked if a HTTP request in GET mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doGet(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in POST mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doPost(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in HEAD mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doHead(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in PUT mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doPut(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in DELETE mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doDelete(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in OPTIONS mode has been received by the SCWS for the
     * associated application.
     *
     * @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doOptions(HttpRequest request, HttpResponse response)
        throws ScwsException;

    /**
     * Invoked if a HTTP request in TRACE mode has been received by the SCWS for the
     * associated application.
     *
     @param request the object containing the HTTP request
     * @param response the object to prepare the response in
     * @throws ScwsException
     */
    public void doTrace(HttpRequest request, HttpResponse response)
        throws ScwsException;

}
