package uicc.connection;

/**
 * The Connection interface represents a data link connection to a remote entity.
 * 
 * Objects implementing <code>Connection</code> and returned by the <code>ConnectionServer.getConnection</code> method
 * are <b>Permanent Entry Point Objects</b>.
 *
  */
public interface Connection
{
    /**
     * Update the connection parameters.<br>
     *
     * This operation can be performed only on <code>Connection</code> objects not allowing the multiplexing.
     * 
     * @param connectionParameters parameters to build up an OPEN CHANNEL command according to ETSI TS 102 223
     * @param sOffset the starting offset of the parameters in the <code>connectionParameters</code> byte array
     * @param sLength the length of the parameters
     * 
     * @exception ArrayIndexOutOfBoundsException if <code>sOffset</code> and <code>sLength</code> are causing access
     *         outside of <code>connectionParameters</code> array bounds
     * @exception ConnectionException with the following reason code:
     *         <ul>
     *              <li><code>INVALID_STATE</code> if the connection is already opened.</li>
     *              <li><code>OPERATION_NOT_ALLOWED</code> if the <code>Connection</code> allows multiplexing.
     *         </ul> 
     * @exception NullPointerException if <code>connectionParameters</code> is equal to <code>null</code>
     */
    public void updateConnectionParameters(byte[] connectionParameters, short sOffset, short sLength)
    		throws ArrayIndexOutOfBoundsException,
    		       ConnectionException,
    		       NullPointerException;

    /**
     * Returns the status of the <code>Connection</code>.
     * 
     * @return <code>true</code> if the Connection is connected, <code>false</code> otherwise. 
     */
    public boolean isConnected();
}
