
package uicc.hci.example;

import javacard.framework.APDU;
import javacard.framework.Applet;
import javacard.framework.AppletEvent;
import javacard.framework.ISOException;
import javacard.framework.JCSystem;
import uicc.hci.framework.HCIDevice;
//import uicc.hci.framework.HCIService;
import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIMessage;
import uicc.hci.services.cardemulation.*;
import uicc.hci.services.connectivity.*;


public class CardEmulationTestApplet extends Applet implements AppletEvent,CardEmulationListener /*,ConnectivityListener*/ {

     //private HCIService CEService;  // at the moment the services are defined as temporary entry point objects so we can not store them in class variables
     private CardEmulationService CEService;
     //private HCIService CTYService;
     private ConnectivityService CTYService;
     private byte[] Buffer;
     private short  Length;
     private short  Offset;
     private final byte  GET_PARAM = -2;
     private final byte  REQUEST_TRANSACTION = -3;

    private CardEmulationTestApplet()
    {

    //init "buffer"
    Buffer = JCSystem.makeTransientByteArray((short)270,JCSystem.CLEAR_ON_RESET);

    try
        {
        //HCI API Part
        CEService = (CardEmulationService) HCIDevice.getHCIService(HCIDevice.CARD_EMULATION_SERVICE_ID);
        CEService.register(this);
        CEService.activateEvent(EVENT_ON_SEND_DATA);

    }
    catch(HCIException e)
        {
        ///////
        }

    }


    @Override
    public void process(APDU arg0) throws ISOException {
        //test
        CEService.requestCallBackNotification(GET_PARAM);
    }

    @Override
    public void deselect() {
        //for possiblity 1 ,especially if the applet is not a CardEmulationListener
        CTYService.requestCallBackNotification(REQUEST_TRANSACTION);
    }

    //Due to AmmC, applet will be selected
    @Override
    public boolean select() {

    //does the connectivity service is available now ??
    CTYService = (ConnectivityService)HCIDevice.getHCIService(HCIDevice.CONNECTIVITY_SERVICE_ID);
    //CTYService.register(this);

    // for possiblity 2 , activateEvent FIELD_OFF
    CEService.activateEvent(EVENT_FIELD_OFF);

    return true;

    }

    public static void install( byte[] bArray, short bOffset, byte bLength  ) throws ISOException {
         CardEmulationTestApplet cardEmu = new CardEmulationTestApplet();
         cardEmu.register();
    }

    public void uninstall() {
        CEService.unregister(this);
        //CTYService.unregister(this);
    }

    public void onCallBackTriggering(byte event, HCIMessage hcimessage)
    {
     CardEmulationMessage message = (CardEmulationMessage) hcimessage;
     switch(event){
         case EVENT_ON_SEND_DATA:

             //differents cases, incoming buffer capacity is inferior
             //to the length of incoming message length

             //case 1)
             //test isHeading() = true
             //test isComplete() = true
             //all datas could be retrieved with one call
             if((message.isComplete())&&(message.isHeading())){
             Buffer = message.getReceiveBuffer();
             Length = message.getReceiveLength();
             Offset = message.getReceiveOffset();

             //process data

             //answer
             message.prepareAndSendSendDataEvent(Buffer, Offset, Length);
             return; //TRIG_NO_MORE_PROCESS;
             }

             //case 2)
             //test isHeading() = true
             //test isComplete() = false
             //first part of the message could be retrieved
             // what left will be retrievable on next "return EVENT_ON_SEND_DATA;"
             if(!(message.isComplete())&&(message.isHeading())){
             Buffer = message.getReceiveBuffer();
             Length = message.getReceiveLength();
             Offset = message.getReceiveOffset();

             //waiting for other data
             //process this part if you want

             return; //EVENT_ON_SEND_DATA;
             }

             //case 3)
             //test isHeading() = false
             //test isComplete() = false
             //first part and maybe other have been retrieved
             // what left will be retrievable on next "return EVENT_ON_SEND_DATA;"

             if(!(message.isComplete())&&!(message.isHeading())){
             Buffer = message.getReceiveBuffer();
             Length = message.getReceiveLength();
             Offset = message.getReceiveOffset();

             //waiting for other data
             //process this part if you want

             return; //EVENT_ON_SEND_DATA;
              }

             //case 4)
             //test isHeading() = false
             //test isComplete() = true
             //last part can be retrieved

             if((message.isComplete())&&!(message.isHeading())){
             Buffer = message.getReceiveBuffer();
             Length = message.getReceiveLength();
             Offset = message.getReceiveOffset();

              return; //TRIG_NO_MORE_PROCESS;
              }

        case GET_PARAM:
            //test
            message.prepareAndSendGetParameterCommmand(CardEmulationMessage.PARAM_ID_TYPE_A_CARD_DATARATE_MAX);
            return; //EVENT_GET_PARAMETER_RESPONSE;

         case EVENT_GET_PARAMETER_RESPONSE:

             //check response
             Buffer = message.getReceiveBuffer();
             Length = message.getReceiveLength();
             Offset = message.getReceiveOffset();

             if((Length != 1)||(Buffer[Offset] != message.RESP_ANY_OK)){

             //notify it !!!
             }

             return; //TRIG_NO_MORE_PROCESS;


         case EVENT_FIELD_OFF:
             // be proper to avoid case where we receive a lot of evts
             CEService.deactivateEvent(EVENT_FIELD_OFF);
             // CTYService.requestCallBackNotification(REQUEST_TRANSACTION);
             CTYService.prepareAndSendTransactionEvent(Buffer, Offset, Offset, Buffer, Offset, Offset);

         return; //TRIG_NO_MORE_PROCESS;

         default:
         return; //TRIG_NO_MORE_PROCESS;
     }
 }

//no need to be selected to process onCallBack ( by default )
 /*
 public byte onCallBackTriggering(byte event, ConnectivityMessage message){

 switch (event){

         case REQUEST_TRANSACTION:
         CTYService.prepareAndSendTransactionEvent(Buffer, Offset, Offset, Buffer, Offset, Offset);
         return TRIG_NO_MORE_PROCESS;

         default:
         return TRIG_NO_MORE_PROCESS;
        }

    }
*/
}

