#! /net/ceres/pkgs/perl/perl5.005-26-ceres/perl
# %W% %E%

# This script generates stubs for for crypto test. This stub includes code for
# loading and sending of the data.
#

my $class_name = shift(@ARGV);
my $author = shift(@ARGV);
my $name = $class_name;
$name =~ s/^(.*)\.([^\.]*)$/\2/;
my $package = $1;
$package = "package $package;" if ($package);
open(RESULT , "> $name.java");

my $macros = "";
print RESULT "/*
 * \%W\% \%E\% $author
 *
 *
 * Copyright 2001 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms
 *
 * This test checks sending and receiving of the crypto data on the
 * test execution framework
 */

$package

import javacard.framework.*;
import javacard.security.*;


public class $name extends Applet {

    /**
     * CLA byte: jcre test class
     */
    private final static byte CLA_JCRE_TEST = (byte)0x80;

    /**
     * INS byte: DoTests command
     */
    private final static byte INS_DO_TESTS  = (byte)0x20;
    private final static byte INS_DATA_TO_CARD = (byte)0x40;
    private final static byte INS_DATA_FROM_CARD = (byte)0x30;

    private final static byte START = (byte)0x01;
    private final static byte PROGRESS = (byte)0x02;
    private final static byte END = (byte)0x04;

    private static final byte CJCK_PASS = (byte)0;
    private static final byte CJCK_FAIL = (byte)1;
    private static final byte CJCK_SW1  = (byte)0x9b;
    private static final byte CJCK_SYSERROR = (byte)0xff;

    private static final byte STATUS_WAIT = (byte)0;
    private static final byte STATUS_FROM_CARD_IN_PROGRESS = (byte)1;
    private static final byte STATUS_ON_CARD_IN_PROGRESS = (byte)3;

    private static final byte CHUNK_SIZE = (byte)32;

    private byte transfer_status;
    private byte[] buff;
    private short data_offset;
    private short bytesReceived = 0;

    /**
     * constructor
     * \@param bArray from install().
     * \@param bOffset from install().
     * \@param bLength from install().
     */
    protected $name(byte bArray[], short bOffset, byte bLength) {
        register();
    }

    /**
     * Installs an applet.
     * \@param bArray to pass to the constructor.
     * \@param bOffset to pass to the constructor.
     * \@param bLength to pass to the constructor.
     */
    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new $name(bArray, bOffset, bLength);
    }

    /*
     * process() - process APDU commands
     */
    public void process(APDU apdu) {
        byte status = CJCK_PASS;
        byte[] buffer = apdu.getBuffer();

        if ((buffer[ISO7816.OFFSET_CLA] == ISO7816.CLA_ISO7816)
            && (buffer[ISO7816.OFFSET_INS] == ISO7816.INS_SELECT)) {
            bytesReceived = apdu.setIncomingAndReceive();
            if (!JCSystem.getAID().equals(buffer, ISO7816.OFFSET_CDATA,
                                          buffer[ISO7816.OFFSET_LC]))
                ISOException.throwIt(ISO7816.SW_APPLET_SELECT_FAILED);
        } else if (buffer[ISO7816.OFFSET_CLA] == CLA_JCRE_TEST) {
            switch (buffer[ISO7816.OFFSET_INS]) {

            case INS_DO_TESTS:	// do one or more tests
                // Lc = number of tests
                // Data = array of test codes
                bytesReceived = apdu.setIncomingAndReceive();
                short numTests = (short)(buffer[ISO7816.OFFSET_LC] & 0xFF);

                // must receive all tests in one block (1-32 tests allowed)
                if (numTests != bytesReceived)
                    ISOException.throwIt(ISO7816.SW_WRONG_LENGTH);

                // get codes of tests to perform from APDU, perform test
                // and overwrite test code byte in buffer with test result
                for (short i = ISO7816.OFFSET_CDATA;
                     i < ((short)(ISO7816.OFFSET_CDATA + numTests)); i++) {
                    buffer[i] = this.doTest(buffer[i]);
                    if (buffer[i] != CJCK_PASS)
                        status = CJCK_FAIL;
                }

                // send response
                apdu.setOutgoingAndSend(ISO7816.OFFSET_CDATA, numTests);
                ISOException.throwIt (Util.makeShort(CJCK_SW1, status));

                break;
            case INS_DATA_TO_CARD: //
                dataToCard(buffer, apdu);
                break;

            case INS_DATA_FROM_CARD:
                dataFromCard(buffer, apdu);
                break;

            default: // unsupported INS
                ISOException.throwIt(ISO7816.SW_INS_NOT_SUPPORTED);
            }
        } else { // unsupported CLA
            ISOException.throwIt(ISO7816.SW_CLA_NOT_SUPPORTED);
        }
        ISOException.throwIt (Util.makeShort(CJCK_SW1, status));
    }


    private void dataFromCard(byte[] buffer, APDU apdu) {
        if (buffer[ISO7816.OFFSET_P1] == START) {
            if (transfer_status == STATUS_WAIT) {
                this.buff = getData(buffer[ISO7816.OFFSET_P2]);
                short len = (short)((this.buff == null)
                                    ? 0 : this.buff.length);
                buffer[ISO7816.OFFSET_CDATA] = (byte)((len >> 8) & 0xFF);
                buffer[(short)(ISO7816.OFFSET_CDATA + 1)] = (byte)(len & 0xFF);
                apdu.setOutgoingAndSend(ISO7816.OFFSET_CDATA, (short)2);
                transfer_status = STATUS_FROM_CARD_IN_PROGRESS;
                data_offset = 0;
            } else {
                error();
            }
        } else if (buffer[ISO7816.OFFSET_P1] == PROGRESS) {
            if ((transfer_status != STATUS_FROM_CARD_IN_PROGRESS)
                || (data_offset >= this.buff.length)) {
                error();
            }
            short len = (short)(this.buff.length - data_offset);
            len = (len > CHUNK_SIZE) ? CHUNK_SIZE : len;
            for (short i = 0; i < len; i++) {
                buffer[(short)(ISO7816.OFFSET_CDATA + i)] = this.buff[(short)(data_offset + i)];
            }
            data_offset += len;
            apdu.setOutgoingAndSend(ISO7816.OFFSET_CDATA, len);
        } else if (buffer[ISO7816.OFFSET_P1] == END) {
            if ((transfer_status != STATUS_FROM_CARD_IN_PROGRESS)
                || (data_offset != this.buff.length)) {
                error();
            }
            transfer_status = STATUS_WAIT;
        }
        ISOException.throwIt(Util.makeShort(CJCK_SW1, CJCK_PASS));
    }

    private void dataToCard(byte[] buffer, APDU apdu) {
        if (buffer[ISO7816.OFFSET_P1] == START) {
            bytesReceived = apdu.setIncomingAndReceive();
            if (buffer[ISO7816.OFFSET_LC] != 2) {
                error();
            }
            short length = Util.makeShort(buffer[ISO7816.OFFSET_CDATA],
                                          buffer[ISO7816.OFFSET_CDATA + 1]);

            if ((length > 0) && (transfer_status ==  STATUS_WAIT)) {
                transfer_status = STATUS_ON_CARD_IN_PROGRESS;
                this.buff = new byte[length];
                data_offset = 0;
            } else {
                error();
            }
        } else if (buffer[ISO7816.OFFSET_P1] == PROGRESS) {
            bytesReceived = apdu.setIncomingAndReceive();

            if (transfer_status != STATUS_ON_CARD_IN_PROGRESS) {
                error();
            }
            short length = Util.makeShort((byte)0, buffer[ISO7816.OFFSET_LC]);
            if ((short)(data_offset + length) > (short)this.buff.length) {
                error();
            }
            for (short i = 0; i < length; i++) {
                this.buff[(short)(data_offset + i)] = buffer[(short)(ISO7816.OFFSET_CDATA + i)];
            }
            data_offset = (short)(data_offset + length);
        } else if (buffer[ISO7816.OFFSET_P1] == END) {
            if ((transfer_status != STATUS_ON_CARD_IN_PROGRESS)
                || (data_offset != (short)this.buff.length)) {
                error();
            }
            putData(this.buff, buffer[ISO7816.OFFSET_P2]);
            transfer_status = STATUS_WAIT;
        }
        ISOException.throwIt (Util.makeShort(CJCK_SW1, CJCK_PASS));
    }

    protected byte[] getData(byte index) {
        // Put code here
    }

    protected void putData(byte[] data, byte index) {
        // Put code here
    }

    private void error() {
        ISOException.throwIt(Util.makeShort(CJCK_SW1, CJCK_SYSERROR));
    }

    private byte doTest(byte index) {
        return index;
    }
}
";
