package uicc.scws;

/**
 * Registry which handles the registration and deregistration of applications and their
 * associated callback objects to the SCWS.
 */
public class ScwsExtensionRegistry
{

    private ScwsExtensionRegistry()
    {
    }

    /**
     * Registers an <code>ScwsExtension</code> with the given name to the SCWS. The
     * application has to provide an object which is responsible for handling the HTTP
     * requests.
     *
     * @param scwsExtension the object handling the HTTP requests
     * @param appId the name of the application
     * @param offset the offset to the name
     * @param length the length of the name
     * @exception NullPointerException if <code>scwsExtension</code> or
     *                <code>appID</code> is equal to null.
     * @exception ArrayIndexOutOfBoundsException if <code>offset</code> 
     * or <code>length</code> or both would cause access outside of the array bounds, 
     * or if <code>length</code> is negative
     * @exception ScwsException with reason <code> SCWSEXTENSION_REGISTRY_ERROR</code>if the <code>appId</code> is already registered
     */
    public static void register(
        ScwsExtension scwsExtension,
        byte[] appId,
        short offset,
        short length) throws ScwsException,NullPointerException, ArrayIndexOutOfBoundsException
    {
    }

    /**
     * Deregisters a <code>ScwsExtension</code> from the Smart Card Webserver.
     *
     * @param scwsExtension the extension to deregister
     * @exception NullPointerException if <code>scwsExtension</code> is equal to null
     * @exception ScwsException with reason <code> SCWSEXTENSION_REGISTRY_ERROR</code> if the <code>scwsExtension</code> has not been registered before
     * @exception SecurityException if the caller has not the same JCRE context than the
     *                one that was used to register the application.
     */
    public static void deregister(ScwsExtension scwsExtension)
        throws ScwsException,NullPointerException, SecurityException
    {
    }
}
