package uicc.connection;

/**
 * This <code>ConnectionServer</code> factory class provides methods to create
 * objects implementing <code>Connection</code>, <code>BIPLink</code> and <code>UICCTransportLink</code>.<br>
 *
 * Any object instanciated by the ConnectionServer is a Permanent Entry Point Object.
 *
 */
public class ConnectionServer
{
    /** Indicating the usage of CAT_TP as transport protocol: 0 */
    public final static byte CAT_TP = (byte) 0x00;

    private ConnectionServer()
    {
    }

    /**
     * Returns an instance providing a data link connection.
     * This instance has to be configured by providing connection parameters before usage.
     * The returned object is a Permanent Entry Point Object.
     * <code>Connection</code> objects created by this methods implictly does not allow multiplexing.
     *
     * @return <code>Connection</code> instance or <code>null</code> if the connection resources are exceeded
     */
    public static Connection getConnection()
    {
    	return null;
    }

    /**
     * Returns an instance providing a data link connection.
     * This instance is configured according to the provided connection parameters.
     * The returned object is a Permanent Entry Point Object.
     *
     * @param baConnectionParameters the parameters to build up an OPEN CHANNEL command according to ETSI TS 102 223
     * @param sOffset the offset to the parameters in the byte array
     * @param sLength the length of the parameters
     * @param multiplexingAllowed if <code>true</code>, indicates whether an already existing <code>Connection</code>
     * 					with the same parameters can be returned, or if the newly created
     *					<code>Connection</code> object can be re-used by another entity.
     *					If <code>false</code>, an new <code>Connection</code> object
     *					is created.
     *
     * @exception NullPointerException if <code>baConnectionParameters</code> is equal to <code>null</code>
     * @exception ArrayIndexOutOfBoundsException if <code>sOffset</code> and <code>sLength</code> are causing access
     *         outside of <code>baConnectionParameters</code> array bounds
     *
     * @return a <code>Connection</code> instance or <code>null</code> if the connection resources are exceeded
     */
    public static Connection getConnection(
    				byte[] baConnectionParameters,
    				short sOffset,
    				short sLength,
    				boolean multiplexingAllowed)
    		throws ArrayIndexOutOfBoundsException,
    		       NullPointerException
    {
    	return null;
    }

    /**
     * Returns an instance providing a connection service which implements a reliable
     * transport protocol.
     * The returned object is a Permanent Entry Point Object.
     *
     * @param bLinkType the kind of reliable mechanism which shall be used for that link
     * @param oConnection the connection to create the reliable link on
     * @param oObserver the Observer to be used for notification about state changes
     *
     * @return a <code>UICCTransportLink</code> instance based on the
     *          delivered connection or <code>null</code> if the connection ressources are exceeded
     *
     * @exception ConnectionException with the following reason code:
     *         <ul>
     *         		<li><code>TRANSPORT_PROTOCOL_NOT_SUPPORTED</code>if the requested
     *         transport protocol type <code>bLinkType</code> is not supported.</li>
     *			<li><code>INVALID_PARAMETERS</code> if <code>oConnection</code> is already in use
     *				and does not support multiplexing.
     *			<li><code>RESOURCE_NOT_AVAILABLE</code> if there are not sufficient
     *                resources available (on the UICC or on the terminal).
     *         </ul>
     * @exception NullPointerException if <code>oConnection</code> or <code>oObserver</code> is equal to <code>null</code>
     */
    public static UICCTransportLink createUICCTransportLink(byte bLinkType, Connection oConnection,
                Observer oObserver)
    		throws ArrayIndexOutOfBoundsException,
    		       ConnectionException,
    		       NullPointerException
    {
    	return null;
    }

   /**
     * Returns an instance providing a connection service without any additional reliable protocol.
     * The returned object is a Permanent Entry Point Object.
     *
     * @param oConnection the connection to create the reliable link on
     * @param oObserver the Observer to be used for notification about state changes
     *
     * @return a <code>BIPLink</code> instance based on the
     *          delivered connection or <code>null</code> if the connection resources are exceeded
     *
     * @exception ConnectionException with the following reason code:
     *         <ul>
     *			<li><code>INVALID_PARAMETERS</code> if <code>oConnection</code> is already in use
     *				or it supports multiplexing.
     *         </ul>
     * @exception NullPointerException if <code>oConnection</code> or <code>oObserver</code> is equal to <code>null</code>
     */
    public static BIPLink createBIPLink(Connection oConnection, Observer oObserver)
    		throws ConnectionException,
    		       NullPointerException
    {
    	return null;
    }

}
