/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIListener;

/** 
 * An instance implementing ReaderListener is used by an Applet
 * to monitor the ReaderService.
  **/

public interface ReaderListener extends HCIListener {

    /**
     * This value is used to notify the Applet when a response to the
     * {@link ReaderMessage#prepareAndSendGetParameterCommand(byte)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /**
     * This value is used to notify the Applet when a response to the
     * {@link ReaderMessage#prepareAndSendWriteXchgDataCommand(byte, byte[], short, short)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     */
    public final static byte EVENT_WRITE_EXCHANGE_DATA_RESPONSE = (byte) 0x02;

    /**
     * This value is used to notify the Applet when the HCI event EVT_TARGET_DISCOVERD
     * as received from the CLF.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_TARGET_DISCOVERED = (byte) 0x50;
}