/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.services.readermode;

import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIMessage;

/** 
 * The ReaderMessage offers specialized methods for generate
 * Contactless Reader command or event.
 **/
public interface ReaderMessage extends HCIMessage {

    /** An application level time-out occurred. */
    public static final byte RESP_ANY_E_TIMEOUT = (byte) 0x09;
    
    /** The target has returned an RF error. */
    public static final byte RESP_WR_RF_ERROR = (byte) 0x10;
 
    /**  when there is a single target in the reader field and 
     * the activation of the target is completed 
     * */
    public final static byte SINGLE_TARGET_STATUS = (byte) 0x00;
    
    /**  
     * when there are several targets in the field irrespective 
     * of the RF technology */
    public final static byte MULTIPLE_TARGET_STATUS = (byte) 0x03;    
    
    // ------------ Type A parameters --------------------
    /** UID as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_UID = (byte)0x02;
    
    /** Pre-formatted ATQA as defined in ISO/IEC 14443-3 for type A
     * (see TS 102 622 for coding of the value)
     */
    public final static byte PARAM_ID_TYPE_A_READER_ATQA = (byte)0x04;
    
    /** The historical bytes as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_APPLICATION_DATA = (byte)0x05;
    
    /** Pre-formatted SAK as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_READER_SAK = (byte)0x03;
    
    /** SFGT Frame waiting time and start-up frame guard time as 
     * defined in ISO/IEC 14443-4 for type A*/
    public final static byte PARAM_ID_TYPE_A_READER_FWI = (byte)06;
    
    /** Maximum data rate supported */
    public final static byte PARAM_ID_TYPE_A_READER_DATARATE_MAX = (byte)0x01;

    // ------------ Type B parameters --------------------
     /** PUPI as defined in ISO/IEC 14443-3 for type B */
    public final static byte PARAM_ID_TYPE_B_READER_PUPI = (byte)0x03;
    
     /** Application data as defined in ISO/IEC 14443-3 for ATQB */
    public final static byte PARAM_ID_TYPE_B_READER_APPLICATION_DATA = (byte)0x04;
    
     /** Application family identifier as defined in ISO/IEC 14443-3 
      * for type B used by the reader to poll the target */
    public final static byte PARAM_ID_TYPE_B_READER_AFI = (byte)0x02;
    
     /** Higher layer response as defined in ISO/IEC 14443-3 for answer 
      * to ATTRIB command */
    public final static byte PARAM_ID_TYPE_B_READER_HIGHER_LAYER_RESPONSE = (byte)0x01;
    
     /** Higher layer data as defined in ISO/IEC 14443-3 for ATTRIB command */
    public final static byte PARAM_ID_TYPE_B_READER_HIGHER_LAYER_DATA = (byte)0x05;

    
    /** 
     * This method builds the HCI command ANY_GET_PARAMETER for the
     * indicated information and sends it to the Contactless Reader Gate of the CLF.
     *
     * The prepareGetParameterCommand method should only be called when the CLF 
     * has successfully discovered a card in the field, i.e. after reception of 
     * the HCI event EVT_TARGET_DISCOVERED.
     * 
     * @param paramID
     * @throws HCIException
     * (editor's note: add exceptions)
     */
    public void prepareAndSendGetParameterCommand(byte paramID) throws HCIException;

    
    /**
     * This method builds the HCI command WR_XCHG_DATA with the data passed
     * in the parameter data and sends it to the Contactless Reader Gate of the CLF.
     * The response data from the CLF will be transferred to the UICC with the event
     * ReaderListener.EVENT_WRITE_EXCHANGE_DATA_RESPONSE.
     * 
     * @param timeout -1 if no timeout, (editor's note: the value is coded on 14 bits 
     * (see TS 102 622), resulting times are 300 used to 4.9 sec. todo: add table 
     * translating byte values in to times).
     * @param data data to send to the CLF
     * @param offset offset of data
     * @param len length of data
     * @throws uicc.hci.framework.HCIException
     * (editor's note: define exceptions, ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION)
     */
    public void prepareAndSendWriteXchgDataCommand(byte timeout, byte[] data, short offset, short len) throws HCIException;
    

    /** 
     * This method sends successively a HCI event EVT_END_OPERATION and a 
     * HCI event EVT_READER_REQUESTED.
     * 
     * This method is intended to recover from the following error states:
     * <li>reception of RESP_ANY_E_TIMEOUT
     * <li>reception of RESP_WR_RF_ERROR 
     * <li>reception of EVT_TARGET_DISCOVERED with a MULTIPLE_TARGET_STATUS
     * @throws HCIException
     * (editor's note: which exceptions? 
     * new reason code 'not activated' or excisting exception: ACCESS_NOT_GRANTED)
     * 
     */
    public void restartReaderModeProcedure() throws HCIException;



}
/******************************************************************************
 * $log: $
 ******************************************************************************/
