/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.*;

/**
 * This class provides a factory to retrieve instances of <code>HCIService</code> subclasses.
 *
 **/
public final class HCIDevice {

    /** Identifies the service object for reader mode functionality */
    public final static short READER_SERVICE_ID = 0x0002;
    
    /** Identifies the service object for card emulation mode functionality */
    public static final short CARD_EMULATION_SERVICE_ID = 0x0003;
    
    /** Identifies the service object for connectivity functionality */
    public final static short CONNECTIVITY_SERVICE_ID = 0x0004;

    /** UICC is activated in low power mode */
    public final static byte LOW_POWER_MODE = (byte) 0x00;
    
    /** UICC is activated in full power mode */
    public final static byte FULL_POWER_MODE = (byte) 0x01;
    

    /**
     * private constructor
     **/
    private HCIDevice() {
    }


    /**
     * This method is used to retrieve instances of HCIService subclasses.
     *
     * @param serviceID shall be one of the constants (*)_SERVICE_ID defined 
     * in this class.
     * @return reference to the temporary JCRE entry point object of the <code>HCIService</code>
     * @throws HCIException with reason:
     * <ul>
     * <li>HCI_ACCESS_NOT_GRANTED if access to the indicated service is
     * not permitted for the Applet (editors's note: sha will check how referencing 
     * is done in TS 102 241, further: list under which circumstances this exception 
     * shall be thrown.)
     * <li>HCI_SERVICE_NOT_AVAILABLE if the requested service type is not available
     * <li>HCI_CURRENTLY_DISABLED is the HCI system is currently disabled
     * </ul>
     * @exception SystemException with the following reason code: <ul>
     *      <li><code>ILLEGAL_VALUE</code> <ul><li>if the serviceID does not match with the predefined values</li></ul>
     *
     **/
    public static HCIService getHCIService(short serviceID) throws HCIException, SystemException {
        return null;
    }

    /**
     * This method returns the current power mode of the UICC as defined in TS 102 622.
     * Possible values are:
     * <ul>
     * <li>LOW_POWER_MODE</li>
     * <li>FULL_POWER_MODE</li>
     * </ul>
     * @return the current power mode or -1 if the power mode can not be retrieved
     */
    public static byte getPowerMode() { return (byte)-1; }

    /**
     * Checks weather HCI services are currently available
     *
     * @return true in case any HCI service is available
     */
    //public static boolean isHCIActive() { return false; }

    /**
     * This method is used to retrieve information about the availability of a HCIService
     * more related to user interface
     *
     * @param serviceID shall be one of the constants (*)_SERVICE_ID defined in this class
     * @return (byte)0x00 if the service is available and can be used
     *         otherwise bit values set to
     *              <ul>
     *              <li> bit 0 set: interface not supported by terminal
     *              <li> bit 1 set: service not supported by terminal
     *              <li> bit 2 set: access not allowed for Applet
     *              <li> bit 3 set: HCI interface currently disabled in UICC
     *              (editor note: the last two could be exceptions)
     *              </ul>
     */
    public static byte isHCIServiceAvailable(short serviceID) { return 0x00; }
}

