package uicc.hci.services.connectivity;

import uicc.hci.framework.*;

/**
 * The connectivity services defines:
 * <ul>
 * <li> a mechanism that allows a UICC to start a proactive session as defined
 * in TS 102 223,
 * 
 * <li> a mechanism to launch an application on the terminal host that
 * is related to the Applet running in the UICC.
 * 
 **/
public interface ConnectivityService extends HCIService {

    /**
     * This method builds the HCI event EVT_CONNECTIVITY which notifies
     * the terminal host that it shall send a "HCI connectivity event"
     * as defined in TS 102 223.
     * @exception HCIException
     */
    public void prepareAndSendConnectivityEvent() throws HCIException;

    /**
     * This method builds the HCI event EVT_TRANSACTION which notifies
     * the terminal host that it shall launch an application on the terminal
     * which is associated to an Applet in the UICC host identified.
     * 
     * @param aid buffer with the AID of the Applet or null, if null the framework
     *        will use the AID of the Applet instance that calls this method
     * @param aidOffset offset in the buffer with the AID
     * @param aidLen AID length
     * @param parameters buffer with the parameters
     * @param parametersOffset offset in the buffer with the parameters
     * @param parametersLen length of the parameters
     * @throws HCIException with the following reason code: <ul> <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled</ul>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     * @exception NullPointerException if <code>parameters</code> is <code>null</code>
     */
    public void prepareAndSendTransactionEvent(
            byte[] aid,
            short aidOffset,
            short aidLen,
            byte[] parameters,
            short parametersOffset,
            short parametersLen)  throws HCIException,ArrayIndexOutOfBoundsException,NullPointerException;
    /**
     * This method builds the HCI event EVT_TRANSACTION which notifies
     * the terminal host that it shall launch an application on the terminal
     * which is associated to an Applet in the UICC host identified.
     * The Contactless Framework shall add the AID of the calling Applet instnce
     * to the HCI event passed to the CLF.
     *
     * @param parameters buffer with the parameters
     * @param parametersOffset offset in the buffer with the parameters
     * @param parametersLen length of the parameters
     * @throws HCIException with the following reason code: <ul> <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled</ul>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     * @exception NullPointerException if <code>parameters</code> is <code>null</code>
     */
    public void prepareAndSendTransactionEvent(
            byte[] parameters,
            short parametersOffset,
            short parametersLen)  throws HCIException,ArrayIndexOutOfBoundsException,NullPointerException;
}

