package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIListener;

/**
 * An instance implementing CardEmulationListener is used by an Applet
 * to monitor the ContactlessCardEmulationService.
 * 
 * @see ContactlessCardEmulationService
 **/
public interface CardEmulationListener extends HCIListener {

    /** This value is used to notify the Applet when a response to the 
     * {@link CardEmulationMessage#prepareAndSendGetParameterCommmand(byte)}
     * is received.
     * The Applet shall return this value to the HCI framework if it 
     * wants to be notified about the outcome of the GetParameterCommand.
     * */
    public final static byte EVENT_GET_PARAMETER_RESPONSE = (byte) 0x01;

    /** This value is used to notify the Applet when the HCI event EVT_SEND_DATA
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_ON_SEND_DATA = (byte) 0x50;

	/** This value is used to notify the Applet when the HCI event EVT_FIELD_ON
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_FIELD_ON = (byte) 0x51;

    /** This value is used to notify the Applet when the HCI event EVT_FIELD_OFF
     * is received.
     * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
     * */
    public final static byte EVENT_FIELD_OFF = (byte) 0x54;

	/** This value is used to trigger the Applet when the HCI event EVT_CARD_DEACTIVATED
    * is received.
    * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
    * */
    public final static byte EVENT_CARD_DEACTIVATED = (byte) 0x52;

   /** This value is used to trigger the Applet when the HCI event EVT_CARD_ACTIVATED
    * is received.
    * This constant can be used in HCIService.activateEvent() and HCIService.deactivateEvent().
    * */
    public final static byte EVENT_CARD_ACTIVATED = (byte) 0x53;


    /** 
     * This method is called by the HCI framework in 3 situations:
     * 1. A predefined condition (see HCIService.activateEvent()) is fulfilled. 
     * 
     * 2. A certain return value on a previous invocation of this method was returned. 
     * 
     * 3. When a previous call to the method HCIService.requestCallBackNotification()from the
     * same Applet was made.
     * 
     *  2. improve wording )
     *
     * 
     * @param  event the condition caused this invocation of this method
     * @param  message the HCIMessage
     * @return condition for next invocation:
     * <ul>
     * <li>{@link uicc.hci.framework.HCIListener#TRIG_NO_MORE_PROCESS}: the listener does
     *  not request to be called back
     * <li> value greater than 0: The listener request to be call back as soon
     * as possible with the given triggering condition. The specific values are 
     * listed in the documentation of the sub interfaces.
     * <li> value less than  0: forbidden (will be ignored).
     * </ul>     
     */
    //public byte onCallBackTriggering(byte callback, CardEmulationMessage message);
}

