package uicc.connection;

import javacard.framework.CardRuntimeException;

/**
 * Exception class for the <code>uicc.connection</code> package.
 * 
 */
public class ConnectionException extends CardRuntimeException
{
    /** Reason code to indicate that the transport protocol type is not supported: 0 */
    public final static short TRANSPORT_PROTOCOL_NOT_SUPPORTED = (short) 0;

    /** Reason code to indicate that a proactive session is pending */
    public final static short TOOLKIT_RESOURCE_NOT_AVAILABLE = (short) 1;

    /** Reason code to indicate that the state of a connection or of a link does not correspond the requested action: 2 */
    public final static short INVALID_STATE = (short) 2;

    /** Reason code to indicate that the requested action was aborted because of a timeout: 3 */
    public final static short TIME_OUT = (short) 3;

    /** Reason code to indicate that the requested action was aborted by the user: 4 */
    public final static short USER_CANCELLATION = (short) 4;

    /** Reason code to indicate that the requested action would cause access out of data: 5 */
    public final static short OUT_OF_DATA_BOUNDARIES = (short) 5;

    /** Reason code to indicate that the requested operation is not allowed at this time: 6 */
    public final static short OPERATION_NOT_ALLOWED = (short) 6;

    /** Reason code to indicate that the connection has been refused by the remote entity: 7 */
    public final static short CONNECTION_REFUSED = (short) 7;

    /** Reason code to indicate that the parameters are invalid: 8 */
    public final static short INVALID_PARAMETERS = (short) 8;
    
    /** Reason code to indicate that the terminal does not support the required mechanisms to perform the action: 9 */
    public final static short UNSUPPORTED_OPERATION = (short) 9;
    
    /** Reason code to indicate that there are insufficient resources
     * on the UICC or on the terminal (e.g. timers:) 10 */
    public final static short RESOURCE_NOT_AVAILABLE = (short) 10;
    /** Reason code to indicate that no SCP81 key could be found to establish the TLS session: 11 */
    public final static short SCP81_KEY_NOT_FOUND = (short) 11;

   
    
        
    /**
     * Construct a ConnectionException instance with the specified reason. To
     * conserve on resources use <code>throwIt()</code> method to re-use the
     * JCRE instance of this class.
     *
     * @param  sReason for the exception
     */
    public ConnectionException(short sReason) 
    {
    	super(sReason);
    }

    /**
     * Throws the JCRE instance of the <code>ConnectionException</code> class with
     * the specified reason.
     *
     * @param  sReason for the exception.
     */
    public static void throwIt(short sReason) 
    		throws ConnectionException 
    {
    }
}
