/******************************************************************************
 *
 ******************************************************************************/
package uicc.hci.framework;

import javacard.framework.Shareable;

/** The tagging interface for all types of HCI listeners.
 * <P> A subinterface of <code>HCIListener</code> interface has to be implemented by an Applet
 * which wants to interact with an <code>HCIService</code>.
 * <P> Each sub interfaces of this interface shall implement a method to process incoming 
 * messages to process HCI messages. 
 * These methods may also support an internal callback triggering requested by the
 * Applet itself.
 *
 * @see uicc.hci.framework.HCIService
 * @see uicc.hci.framework.HCIMessage
 **/
public interface HCIListener extends Shareable {

    // --------------- triggering values --------------------
    /** this value must be used as return value by an HCIListener to indicate to
     *  to the framework when it does not want to be called back ??anymore??.
     */
    //public final static short TRIG_NO_MORE_PROCESS = (short) 0x0000;

    /** This method is called by the HCI framework in 3 situations:
     * <ul>
     * <li>1. A predefined condition (see HCIService.activateEvent()) is fulfilled.
     * 
     * <li>2. A certain return value on a previous invocation of this method was returned.
     * 
     * <li>3. When a previous call to the method HCIService.requestCallBackNotification() from the
     * same Applet was made.
     * </ul>
     *  2. improve wording )
     * 
     * @param  event that triggers the invocation of the method
     * @param  message the HCIMessage
     * @return condition for next invocation of this method must, the value may be one
     *         of the event values defined in one of the subinterfaces.
     * <ul>
     * <li> <code>TRIG_NO_MORE_PROCESS</code>: the listener does not request to be called back
     * <li>all other values are defined in subinterfaces
     * </ul>
     */
    //public byte onCallBackTriggering(byte event, HCIMessage message);
    public void onCallBackTriggering(byte event, HCIMessage message);
}
