package uicc.hci.services.cardemulation;

import uicc.hci.framework.HCIException;
import uicc.hci.framework.HCIMessage;

/** The CardEmulationMessage offers specialized methods to generate
 *  card emulation commands or events.
 **/
public interface CardEmulationMessage extends HCIMessage {

	
    // ------------ Type A parameters --------------------
    /** Type A card emulation enabled indicator */
    public final static byte PARAM_ID_TYPE_A_CARD_MODE = (byte) 0x01;
    
    /**  UID as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_CARD_UID_REG = (byte) 0x02;
    
    /**  Pre-formatted SAK as defined in ISO/IEC 14443-3 for type A */
    public final static byte PARAM_ID_TYPE_A_CARD_SAK = (byte) 0x03;
    
    /** Pre-formatted ATQA; byte 1 shall contain b8..1, byte 2 b16..9 of the ATQA coded as defined in ISO/IEC 14443- 3 [6] for type A */
    public final static byte PARAM_ID_TYPE_A_CARD_ATQA = (byte) 0x04;
    
    /** The historical bytes as defined in ISO/IEC 14443-4 for type A */
    public final static byte PARAM_ID_TYPE_A_CARD_APPLICATION_DATA = (byte) 0x05;
    
    /** Frame waiting time and Start-up frame guard time as defined in ISO/IEC 14443-4 for type A */
    public final static byte PARAM_ID_TYPE_A_CARD_FWI_SFGI = (byte) 0x06;
    
    /** support for CID as defined ISO/IEC 14443-4  */
    public final static byte PARAM_ID_TYPE_A_CARD_CID_SUPPORT = (byte) 0x07;
    
    /** Support of tunneling mode for ISO/IEC 14443-4 [7] non compliant protocols  */
    public final static byte PARAM_ID_TYPE_A_CARD_CLT_SUPPORT = (byte) 0x08;
    
    /** Maximum data rate supported */
    public final static byte PARAM_ID_TYPE_A_CARD_DATARATE_MAX = (byte) 0x09;
    

    // ------------ Type B parameters --------------------
    /** Type B card emulation enabled indicator */
    public final static byte PARAM_ID_TYPE_B_CARD_MODE = (byte) 0x01;
    
    /** PUPI as defined in ISO/IEC 14443-3 [6] for type B. */
    public final static byte PARAM_ID_TYPE_B_CARD_PUPI_REG = (byte) 0x02;
    
    /** Application family identifier as defined in ISO/IEC 14443-3 [6] for type B */
    public final static byte PARAM_ID_TYPE_B_CARD_AFI = (byte) 0x03;
    
    /** Additional data for ATQB */
    public final static byte PARAM_ID_TYPE_B_CARD_ATQB = (byte) 0x04;
    
    /** Higher Layer response in answer to ATTRIB command as defined in ISO/IEC 14443-3 [6] for type B */
    public final static byte PARAM_ID_TYPE_B_CARD_HIGHER_LAYER_RESPONSE = (byte) 0x05;
    
    /** Maximum data rate supported */
    public final static byte PARAM_ID_TYPE_B_CARD_DATARATE_MAX = (byte) 0x06;

    // ------------ Type B' parameters --------------------
    /** Type B' card emulation enabled indicator */
    public final static byte PARAM_ID_TYPE_B_PRIME_CARD_MODE = (byte) 0x01;
    
    /** Pattern to match with the incoming data */
    public final static byte PARAM_ID_TYPE_B_PRIME_CARD_PAT_IN = (byte) 0x02;
    
    /** Data to reply if the incoming data matches with PAT_IN pattern */
    public final static byte PARAM_ID_TYPE_B_PRIME_CARD_DAT_OUT = (byte) 0x03;
    

    // ------------ Type F parameters --------------------
    /** Type F card emulation enabled indicator */
    public final static byte PARAM_ID_TYPE_F_CARD_MODE = (byte) 0x01;
    
    /** CLF Speed Capabilities for Type F */
    public final static byte PARAM_ID_TYPE_F_CARD_SPEED_CAP = (byte) 0x02;
    
    /** Support of tunnelling mode for anti-collision data exchange in type F card emulation */
    public final static byte PARAM_ID_TYPE_F_CARD_CLT_SUPPORT = (byte) 0x03;
    
	
    /** 
     * This non-blocking method builds the HCI command ANY_GET_PARAMETER for the
     * indicated information and sends it to the appropriate Card RF Gate of the CLF.
     * @param paramID constant PARAM_ID_* indicating the requested value
     * @throws HCIException with the following reason code: <ul>
     *         <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled
     *         <li><code>HCI_FRAGMENTED_MESSAGE_ONGOING</code> if the Contactless Framework is still receiving a fragmented HCI Message
     *         <li><code>HCI_RESOURCES_NOT_AVAILABLE</code> if the contactless framework does not have enough resources to process the command
     *         </ul>
     */
    public void prepareAndSendGetParameterCommand(byte paramID) throws HCIException;

    /**
     * This non-blocking method builds the the HCI event EVT_SEND_DATA sends it to the
     * Contactless Card Emulation Gate of the CLF.
     * @param data to be sent formated accordng to he HCI specification
     * @param offset of data into the data buffer
     * @param len length of data in the data buffer
     * @throws HCIException with the following reason code: <ul>
     *     <li><code>HCI_CURRENTLY_DISABLED</code> if the HCI interface was disabled
     *     <li><code>HCI_FRAGMENTED_MESSAGE_ONGOING</code> if the Contactless Framework is still receiving a fragmented HCI Message
     *     <li><code>HCI_RESOURCES_NOT_AVAILABLE</code> if the contactless framework does not have enough resources to process the command
     *     </ul>
     * @exception NullPointerException  if <code>data</code> is <code>null</code>
     * @exception ArrayIndexOutOfBoundsException if operation would cause access of data outside
     *            array bounds.
     *
     */
    public void prepareAndSendSendDataEvent(byte[] data, short offset, short len) throws HCIException,
                                                                                         NullPointerException,
                                                                                         ArrayIndexOutOfBoundsException;

    /**
     * This method is used by the applet to distinguish the HCI Message command 
     * which selected this applet from all other HCI messages.
     *
     * @return true if the current HCI message caused the selection of the Applet
     *         according to the rules in GlobalPlatform Amendment C[4]
     */
    public boolean selectingMessage();
}

