/**
 * Workfile: %W%
 * Original author: Maxim V. Sokolnikov
 * Last modified by @author Maxim V. Sokolnikov  Modified: %G% %T%
 *
 * Copyright 2000-2001 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms
 *
 */

package javasoft.sqe.jc_tck_internal;

import java.io.File;
import java.util.Map;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.TestDescription;

public class DistrTestDescription extends TestDescription {
    
    public static final String CLIENT_SOURCES = "client_source";
    public static final String KEYWORDS = "keywords";
    public static final String EXECUTE_ARGS = "executeArgs";
    public static final String SELECT_IF = "selectIf";
    
    public static final String INT_SUPPORT_ARG = " -s -PC-i";
    
    private String[] clientSources = new String[0];

    public DistrTestDescription(File root, File file, Map params) {
        super(root, file, removeSpecific(params));
        String sources = (String)params.get(CLIENT_SOURCES);
        if (sources == null) {
            clientSources = new String[0];
        } else {
            StringTokenizer tokens = new StringTokenizer(sources, " ");
            clientSources = new String[tokens.countTokens()];
            for (int i = 0; i < clientSources.length; i++) {
                clientSources[i] = tokens.nextToken();
            }
        }
    }

    public String[] getClientSources() {
        return (String[])clientSources.clone();
    }

    public File[] getClientSourcesFiles() {
        String dir  = getFile().getParent();
        String[] srcs = getClientSources();
        File[] sourceFiles = new File[srcs.length];
        for (int i = 0; i < srcs.length; i++) {
            sourceFiles[i] = new File(dir, srcs[i].replace('/', File.separatorChar));
        }
        return sourceFiles;
    }
    
    public static Map removeSpecific(Map source) {
        HashMap retVal = new HashMap();
        for (Iterator e = source.keySet().iterator(); e.hasNext();) {
            Object key = e.next();
            retVal.put(key, source.get(key));
        }
        String keys = (String)retVal.get(KEYWORDS);
        if ((keys.indexOf("runtime") < 0)  && (keys.indexOf("execute") < 0)) {
            retVal.put(KEYWORDS, retVal.get(KEYWORDS) + " runtime");
        }
        String selectIf = (String)retVal.get(SELECT_IF);
        if (isRequireIntSupport((String)retVal.get(SELECT_IF))) {
            retVal.put(EXECUTE_ARGS, retVal.get(EXECUTE_ARGS) + INT_SUPPORT_ARG);
        }
        retVal.remove(CLIENT_SOURCES);
        return retVal;
    }

    public static boolean isRequireIntSupport(String selectIf) {
        return (selectIf != null) && (selectIf.indexOf("int_support") >= 0);
    }
}

