/*
 * %W% %E%
 *
 * Copyright (c) 2001 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */

package javasoft.sqe.jc_tck_internal;

import java.io.File;
import java.io.PrintWriter;
import java.util.Dictionary;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.jck.lib.JCKScript;

public class DistrPrecompileScript extends PrecompileScript {

    public static final String CLIENT_COMPILE = "clientCompile";
    private String precompileClassDir;

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        Status stat = super.run(args,td, env);
        for (int i = 0; i < args.length; i++) {
            if (args[i].equals("-precompileClassDir") && i+1 < args.length) {
                setPrecompileClassDir(args[++i]);
                break;
            }
        }

        return (stat.isPassed()) ? compileClientSources(args, td, env) : stat;
    }

    public Status compileClientSources(String[] args, TestDescription td,
                                       TestEnvironment env) {
        if (td instanceof DistrTestDescription) {
            /* */
            PrintWriter trOut = getTestResult().getTestCommentWriter();
            // ... javac step
            trOut.println("Precompiling client source files...");
            File[] srcs = ((DistrTestDescription)td).getClientSourcesFiles();
            if ((srcs == null) || (srcs.length == 0)) {
                return Status.passed("");
            }

            boolean allJavaSrc = true; // assume true until proven otherwise
            for (int i = 0; i < srcs.length && allJavaSrc; i++) {
                String srcPath = srcs[i].getPath();
                allJavaSrc = srcPath.endsWith(".java");
            }
	    
            Status compileStatus;
            if (!allJavaSrc)
                compileStatus = compileIndividually(CLIENT_COMPILE, srcs);
            else if (precompileClassDir != null) 
                compileStatus = compileIfNecessary(CLIENT_COMPILE, srcs, precompileClassDir);
            else
                compileStatus = compileTogether(CLIENT_COMPILE, srcs);
            // proceeding to rmic.
            if (!compileStatus.isPassed())
                return error_compFailUnexp.augment(compileStatus);
            
            return compileStatus;
            /* */
        } else {
            return Status.passed("");
        }
    }
    public void setPrecompileClassDir(String d) {
        precompileClassDir = d;
        super.setPrecompileClassDir(d);
    }
}
