/**
 * Workfile: @(#)DistrHTMLTestFinder.java	1.3
 * Original author: Maxim V. Sokolnikov
 * Last modified by @author Maxim V. Sokolnikov  Modified: 04/03/03 16:47:39
 *
 * Copyright 2000-2001 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms
 *
 */

package javasoft.sqe.jc_tck_internal;

import java.io.File;
import java.util.Map;
import java.util.Iterator;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.StringTokenizer;

import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.TestDescription;

public class DistrHTMLTestFinder extends HTMLTestFinder {

    private Hashtable testsInFile = new Hashtable();

    public void read(File file) {
        testsInFile.clear();
        super.read(file);
    }
    public TestDescription[] getTests() {
        TestDescription[] retVal = super.getTests();
        return retVal;
    }
    
    protected void foundTestDescription(Map entries, File file, int line) {
        try {
            entries = normalize(entries);
            
            if (debug) {
                
                System.err.println("Found TestDescription");
            
                System.err.println("--------values----------------------------");
                for (Iterator e = entries.keySet().iterator() ; e.hasNext() ;) {
                    Object key = e.next();
                    System.err.println(">> " + key + ": " + entries.get(key) );
                }
                System.err.println("------------------------------------------");
            }

            String id = (String)(entries.get("id"));
            if (id == null)
                id = "";

            // make sure test has unique id within file
            Object prevLine = testsInFile.get(id);
            if (prevLine != null) {
                int i = 1;
                String newId;
                while (testsInFile.get(newId = (id + "__" + i)) != null)
                    i++;
            
//            if (errHandler != null) {
                localizedError("Warning: tests found with non-unique id within file"
                               + "file: " + file
                               + "id: " + (id.equals("") ? "(unset)" : id)
                               + "line number of this occurrence: " + line
                               + "line number of first occurrence: " + prevLine
                               + "this occurrence has been automatically renamed to " + newId);
//            }
            
                id = newId;
                entries.put("id", id);
            }

            testsInFile.put(id, new Integer(line));

            // create the test description
            TestDescription td = createTestDescription(getRoot(), file, entries);
        
//        if (errHandler != null) {
            // more checks: check that the path does not include white space,
            // because the exclude list parser does not handle paths with whitespace
            String rru = td.getRootRelativeURL();
            if (rru.indexOf(' ') != -1) {
                localizedError("A test has been found whose path includes a space character"
                               + "file: " + td.getRootRelativeURL());
            }
//        }
            foundTestDescription(td);
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected TestDescription createTestDescription(File root, File file,
                                                    Map entries) {
        return new DistrTestDescription(root, file, entries);
    }
}

