/*
 * @(#)RuntimeFilter.java	1.6 03/07/28
 *
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved. 
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.tgxml.tools.filter.plugins;

import java.util.ArrayList;

import com.sun.tgxml.tjtf.api.tests.TestItem;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.Library;
import com.sun.tgxml.tjtf.api.tests.TestCase;
import com.sun.tgxml.tjtf.api.attributes.Attributes;
import com.sun.tgxml.tjtf.api.attributes.TargetSpec;
import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.code.SupportClass;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.util.IR;

import com.sun.tgxml.tools.filter.processors.FilterFactory;
import com.sun.tgxml.tools.filter.processors.FilterExpression;
import com.sun.tgxml.tools.filter.processors.FilteringException;
import com.sun.tgxml.tools.filter.processors.NodeTRUE;

import com.sun.tgxml.tools.elgen.ExcludeListUtils;
import com.sun.tgxml.tools.elgen.IncorrectAttributesException;

/**
 * Sample plugin for filtering component.
 * Selects only target objects which correspond to the 3.0 level of Unicode spec and 2.0 level of JLS.
 *
 * @author   Seguei I. Katkov
 */
public class RuntimeFilter extends FilterFactory {

    public FilterExpression cfgRead(String configuration) {
        return new NodeTRUE();
//         return createAND(
//             createAND(createAND(createAND(new ExcludedTestBugFilterNode(), new TargSpecUnicode30()),
//             new RuntimeFilterNode()), new TargSpecJLS2()), new TargSpecJDK());
    }
}

class TargSpecUnicode30 extends NodeTRUE {

    static TargetSpec findSpec(ArrayList specs) {
        for (int j = specs.size() - 1; j >= 0; j--) {
            TargetSpec s = (TargetSpec)specs.get(j);
            String id = s.getID();
            if ( id != null && "UNICODE".equals(id.toUpperCase()))
                return s;
        }
        return null;
    }

    static boolean acceptableVersion(TargetSpec s) {
        int major = s.getMajor();
        int minor = s.getMinor();
        return major==3 && minor == 0;
    }

    static boolean acceptItem(TestItem ti) {
        Attributes attrs = ti.getAttributes();
        if (attrs == null)
            return true;
        TargetSpec s = findSpec(attrs.getTargetSpecs());
        if (s == null)
            return true;
        return acceptableVersion(s);
    }

    // -----------------------------------------------------------------

    /** 
     *  TargetSpec attr of the TestGroup only provides default value for the attr of TestCases 
     */
    public boolean accept(TestGroup tg) {
        return acceptItem(tg);
    }

    public boolean accept(Library lib) {
        return acceptItem(lib);
    }

    public boolean accept(TestCase tc, TestGroup tg) {
        return acceptItem(tc);
    }

    public boolean accept(SupportClass cls, CodeSet cs) {
        return false;
    }
    
    public FilterExpression getRelevant(SupportClass sClass) {
        return null;
    }
}

class ExcludedTestBugFilterNode extends NodeTRUE {

    public static boolean notExcludedWithTestBug(TestItem ti) {
        String exLine = IR.getAttrElem(ExcludeListUtils.ExcludedAttrElemName, ti);
        if (exLine != null) {
            return exLine.indexOf("test_bug") < 0;
        } else {
            return true;
        }    
    }

    // -----------------------------------------------------------------

    public boolean accept(TestGroup tg) {
        return notExcludedWithTestBug(tg);
    }

    public boolean accept(TestCase tc, TestGroup tg) {
        return notExcludedWithTestBug(tc);
    }

    public FilterExpression getRelevant(Library lib) {
        return null;
    }

    public FilterExpression getRelevant(SupportClass cls) {
        return null;
    }
}

class NegCompilerFilterNode extends NodeTRUE {

    public boolean accept(TestGroup tg) {
        TestGroupAttributes tgAttrs = tg.getTGAttributes();
        if (tgAttrs == null)
            return true;

        ArrayList kwds = tgAttrs.getKeywords();
        boolean negative = false;
        boolean compiler = false;

        for (int j = kwds.size()-1; j >= 0; j--) {
            Object oj = kwds.get(j);
            negative |= "negative".equals(oj);
            compiler |= "compiler".equals(oj);
        }

        return ! (negative && compiler);
    }

    public FilterExpression getRelevant(TestCase tCase) {
        return null;
    }
    
    public FilterExpression getRelevant(Library lib) {
        return null;
    }

    public FilterExpression getRelevant(SupportClass cls) {
        return null;
    }
}

class RuntimeFilterNode extends NodeTRUE {

    public boolean accept(TestGroup tg) {
        TestGroupAttributes tgAttrs = tg.getTGAttributes();
        if (tgAttrs == null)
            return true;

        ArrayList kwds = tgAttrs.getKeywords();

        for (int j = kwds.size()-1; j >= 0; j--) {
            if ("runtime".equals(kwds.get(j))){
                return true;
            }
        }
        return false;
    }

    public FilterExpression getRelevant(TestCase tCase) {
        return null;
    }
    
    public FilterExpression getRelevant(Library lib) {
        return null;
    }

    public FilterExpression getRelevant(SupportClass cls) {
        return null;
    }
}

class TargSpecJLS2 extends NodeTRUE {

    static TargetSpec findSpec(ArrayList specs) {
        for (int j = specs.size() - 1; j >= 0; j--) {
            TargetSpec s = (TargetSpec)specs.get(j);
            String id = s.getID();
            if ( id != null && "JLS".equals(id.toUpperCase()))
                return s;
        }
        return null;
    }

    static boolean acceptableVersion(TargetSpec s) {
        int major = s.getMajor();
        int minor = s.getMinor();
        return major==2 && minor == 0;
    }

    static boolean acceptItem(TestItem ti) {
        Attributes attrs = ti.getAttributes();
        if (attrs == null)
            return true;
        TargetSpec s = findSpec(attrs.getTargetSpecs());
        if (s == null)
            return true;
        return acceptableVersion(s);
    }

    // -----------------------------------------------------------------

    /** 
     *  TargetSpec attr of the TestGroup only provides default value for the attr of TestCases 
     */
    public boolean accept(TestGroup tg) {
        return acceptItem(tg);
    }

    public boolean accept(TestCase tc, TestGroup tg) {
        return acceptItem(tc);
    }

    public FilterExpression getRelevant(SupportClass sClass) {
        return null;
    }

    public FilterExpression getRelevant(Library lib) {
        return null;
    }
}

class TargSpecJDK extends NodeTRUE {

    static ArrayList findSpec(ArrayList specs) {
        ArrayList toReturn = new ArrayList();
        for (int j = specs.size() - 1; j >= 0; j--) {
            TargetSpec s = (TargetSpec)specs.get(j);
            String id = s.getID();
            if ( id != null && "JDK".equals(id.toUpperCase())) {
                toReturn.add(s);
            }
        }
        return toReturn;
    }

    static int compareVersion(TargetSpec ts1, TargetSpec ts2) {
        if (ts1.getMajor() < ts2.getMajor()) {
            return -1;
        } else if (ts1.getMajor() > ts2.getMajor()) {
            return 1;
        } else if (ts1.getMinor() < ts2.getMinor()) {
            return -1;
        } else if (ts1.getMajor() > ts2.getMajor()) {
            return 1;
        } else if (ts1.getMinor() < ts2.getMinor()) {
            return -1;
        } else if (ts1.getMinor() > ts2.getMinor()) {
            return 1;
        } else {
            return 0;
        }
    }

    static boolean acceptItem(TestItem ti) {
        Attributes attrs = ti.getAttributes();
        if (attrs == null) {
            return true;
        }
        ArrayList s = findSpec(attrs.getTargetSpecs());
        // No JDK spec
        if (s.isEmpty()) {
            return true;
        }
        // Parse specification
        String currentVersion = BuildProperties.getString("spec.jdk.version");
        if (currentVersion == null) {
            return true;
        }
        int point = currentVersion.indexOf('.');
        int currentMajor = 0;
        int currentMinor = 0;
        try {
            currentMajor = Integer.parseInt(currentVersion.substring(0,point));
            currentMinor = Integer.parseInt(currentVersion.substring(point+1));
        } catch (NumberFormatException nfe) {
            nfe.printStackTrace(System.err);
            throw new RuntimeException ("Incorrect version number in the property file: " + currentVersion);
        } catch (IndexOutOfBoundsException ibe) {
            ibe.printStackTrace();
            throw new RuntimeException ("Incorrect version number in the property file: " + currentVersion);
        }
        
        // Cases 1.3- or -1.3
        if (s.size() == 1) {
            return ((TargetSpec) s.get(0)).inSpec(currentMajor, currentMinor);
        }

        // ascending sorting of spec list, bubble sort
        for (int i = 0; i < s.size(); i++) {
            TargetSpec spec = (TargetSpec) s.get(i);
            if (spec.getMajor() == currentMajor && 
                    spec.getMinor() == currentMinor) {
                // exact matching
                return true;
            }
            if (!spec.isUpperModifierSet() && !spec.isLowerModifierSet()) {
                // Case spec=1.4, remove it
                s.remove(i--);
                continue;
            }
            for (int j = 0; j < i ; j++) {
                TargetSpec ts = (TargetSpec) s.get(j);
                int compare = compareVersion(ts, spec);
                if (compare == -1) {
                    // a  < a   - skip
                    //  j    i
                    continue;
                } else if (compare == 1) {
                    // a  > a   - place a  before a
                    //  j    i             i         j
                    s.remove(i);
                    s.add(j, spec);
                    break;
                } else {
                    if ((spec.isUpperModifierSet() && ts.isUpperModifierSet()) ||
                            (spec.isLowerModifierSet() && ts.isLowerModifierSet())) {
                        // case 1.3- , 1.3- or -1.3, -1.3 ; remove extra element
                        s.remove(i--);
                        break;
                    } else {
                        // case 1.3- , -1.3 ; remove both
                        s.remove(i--);
                        s.remove(j);
                        i--;
                        if (s.isEmpty()) {
                            // All specs are removed, e.g. -1.3, 1.3- ; so, false
                            return false;
                        }
                        break;
                    }
                } 
            }
        }
        if (s.isEmpty()) {
            return true;
        }
        // find left and right bounds
        int indexRight = 0;
        for (int i = 0; i < s.size(); i++) {
            TargetSpec spec = (TargetSpec)s.get(i);
            if ((spec.getMajor() > currentMajor) || 
                    ((spec.getMajor() == currentMajor) && 
                    (spec.getMinor() > currentMinor))) {
                break;
            } else {
                ++indexRight;
            }
        }
        if (indexRight == 0) {
            // spec under test < all specs
            return ((TargetSpec)s.get(indexRight)).inSpec(currentMajor, currentMinor);
        } else if (indexRight == s.size()) {
            // spec under test > all specs
            return ((TargetSpec)s.get(indexRight - 1)).inSpec(currentMajor, currentMinor);
        }
        TargetSpec leftsp = (TargetSpec)s.get(indexRight - 1);
        TargetSpec rightsp = (TargetSpec)s.get(indexRight);
        if (leftsp.isLowerModifierSet() && rightsp.isUpperModifierSet()) {
            // case -1.3 , 1.5-
            return false;
        } else {
            // case 1.3-, -1.5
            return true;
        }
    }

    // -----------------------------------------------------------------

    /** 
     *  TargetSpec attr of the TestGroup only provides default value for the attr of TestCases 
     */
    public boolean accept(TestGroup tg) {
        return acceptItem(tg);
    }

    public boolean accept(TestCase tc, TestGroup tg) {
        return acceptItem(tc);
    }
}
