/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.me.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class User {
    public static final String YES = "yes";
    public static final String YES_SHORT = "y";
    public static final String NO = "no";
    public static final String NO_SHORT = "n";

    public void log(Throwable e) {
        e.printStackTrace();
    }

    public static interface UserConfirmation {
        public void log(String message);
        public String ask(String message);
    }

    public static UserConfirmation createNotInteractiveUser(final PrintWriter out) {
        return new UserConfirmation() {

            public void log(String message) {
                out.println(message);
                out.flush();
            }

            public String ask(String message) {
                log(message);
                return YES;
            }
        };
    }

    public static final UserConfirmation NOT_INTERACTIVE = new UserConfirmation() {

        public void log(String message) {
            System.out.println(message);
        }

        public String ask(String message) {
            return YES;
        }
    };

    public static final UserConfirmation INTERACTIVE = new UserConfirmation() {
        private BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

        public void log(String message) {
            System.out.println(message);
        }

        public String ask(String message) {
            log(message);
            try {
                return in.readLine();
            } catch (IOException ex) {
                return "Exception:" + ex;
            }
        }
    };

    public void log(String message) {
        impl.log(message);
    }

    private UserConfirmation impl;
    public  User(UserConfirmation impl) {
        this.impl = impl;
    }

    public void checkYes(String question) {
        String answer = impl.ask(question);
        if (!isYesResponse(answer)) {
            throw new IllegalArgumentException("Interrupted:" + answer);
        }
    }
    public boolean isYes(String question) {
        String answer = impl.ask(question);
        return isYesResponse(answer);
    }
    public static boolean isYesResponse(String answer) {
        return ((answer != null)
                && (answer.equalsIgnoreCase(YES)
                    || answer.equalsIgnoreCase(YES_SHORT)
                    || answer.equalsIgnoreCase("true"))
                    || answer.equalsIgnoreCase(""));
    }
}
