/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.me.utils;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author Maxim V. Sokolnikov
 */
class Converters {
    static Map<String, Converter> defaultConverters;

    public static Object convert(Class to, String arg) throws Exception {
        if (defaultConverters == null) {
            defaultConverters = createConverters();
        }
        Converter cv = defaultConverters.get(to.getName());
        return (cv == null) ? null : cv.convert(Collections.singletonList(arg));
    }

    public static final Converter TO_ARRAY = new Converter() {
            public Object convert(List<String> value) throws Exception {
                if (value == null) {
                    return null;
                }
                return value.toArray(new String[value.size()]);
            }
    };
    static Map<String, Converter> createConverters() {
        Map<String, Converter> retVal = new HashMap<String, Converter>();
        retVal.put(Integer.TYPE.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return new Integer((String)value);
                       }
                   });
        retVal.put(Boolean.TYPE.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String ob) throws Exception {
                           String value = ob.trim();
                           return Boolean.valueOf("true".equalsIgnoreCase(value)
                                                  || "yes".equalsIgnoreCase(value));
                       }
                   });
        retVal.put(Float.TYPE.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return new Float(value);
                       }
                   });
        retVal.put(File.class.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return new File(value);
                       }
                   });
        retVal.put(String.class.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return value;
                       }
                   });
        retVal.put(CommandAPDU.class.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return new CommandAPDU(Utils.parse(value));
                       }
                   });
        retVal.put(AppletID.class.getName(),
                   new SingleArgumentConverter() {
                       public Object convertElement(String value) throws Exception {
                           return new AppletID(Utils.parse(value));
                       }
                   });
        retVal.put(String[].class.getName(), TO_ARRAY);
        return retVal;
    }
}
interface Converter {
    public Object convert(List<String> value) throws Exception;
}
abstract class SingleArgumentConverter implements Converter {
    public abstract Object convertElement(String value) throws Exception;

    public Object convert(List<String> list) throws Exception {
        if ((list == null) || (list.size() == 0)) {
            return null;
        }
        return convertElement(list.get(0));
    }
}
