/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.me.utils;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class Closables implements Closable {
    private final ArrayList<Closable> list = new ArrayList<Closable>();
    private boolean directOrder = false;

    public Closables() {
    }

    public void setDirectOrder(boolean order) {
        this.directOrder = order;
    }

    public void close() {
        this.close(null);
    }

    public void close(PrintWriter log) {
        ArrayList<Closable> actions = new ArrayList<Closable>();
        synchronized (list) {
            actions.addAll(list);
            list.clear();
        }
        if (!directOrder) {
            Collections.reverse(actions);
        }
        for (Closable action : actions) {
            try {
                action.close();
            } catch (Exception e) {
                // ignore.
                if (log != null) {
                    log.println("While closing Closables");
                    e.printStackTrace(log);
                }
            }
        }
    }
    
    public Closables(Closable[] list) {
        Utils.addArrayToCollection(this.list, list);
    }
    
    public void add(Closable element) {
        synchronized (this.list) {
            this.list.add(element);
        }
    }

    public Socket add(Socket socket) {
        add(get(socket));
        return socket;
    }


    public ServerSocket add(ServerSocket socket) {
        add(get(socket));
        return socket;
    }

    public InputStream add(InputStream in) {
        add(get(in));
        return in;
    }


    public OutputStream add(OutputStream out) {
        add(get(out));
        return out;
    }

    public Reader add(final Reader reader) {
        add(new Closable() {
                public void close() throws Exception {
                    reader.close();
                }
            });
        return reader;
    }

    public Writer add(final Writer writer) {
        add(new Closable() {
                public void close() throws Exception {
                    writer.close();
                }
            });
        return writer;
    }


    public static Closable get(final Socket socket) {
        return new Closable() {
            public void close() throws Exception {
                socket.close();
            }
        };
    }

    public static Closable get(final ServerSocket socket) {
        return new Closable() {
            public void close() throws Exception {
                socket.close();
            }
        };
    }

    public static Closable get(final InputStream in) {
        return new Closable() {
            public void close() throws Exception {
                in.close();
            }
        };
    }

    public static Closable get(final OutputStream out) {
        return new Closable() {
            public void close() throws Exception {
                out.close();
            }
        };
    }

    public static Closable getRestore(final SecurityManager manager) {
        return new Closable() {
                public void close() throws Exception {
                    System.setSecurityManager(manager);
                }
            };
    }     
}
