/*
 * %W% %E%
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.gui;

import javax.swing.JDialog;
import javax.swing.JLabel;
import java.awt.Frame;
import javax.swing.GroupLayout;

import com.sun.javacard.cjck.I18n;
import javax.swing.JButton;

import static javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE;
import static javax.swing.SwingConstants.CENTER;

/*
 * Dialog that asks user to insert a card into a terminal
 * indicated by label
 *
 * @author Mikhail Smirnov
 */
public class RemoveCardDialog extends JDialog {


    private JLabel msgLabel;
    private JButton cancelButton;

    /** Creates new form InsertCardDialog */
    public RemoveCardDialog(Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {

        msgLabel = new JLabel();
        int horSize = 600;
        int verSize = 80;
        setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
        setTitle(I18n.getString("remove.card"));
        setAlwaysOnTop(true);
        setIconImage(null);
        setIconImages(null);
        setModal(true);
        setResizable(false);
        setSize(horSize, verSize);
        setLocation(getToolkit().getScreenSize().width/2 - horSize/2,
                getToolkit().getScreenSize().height/2 - verSize/2);

        msgLabel.setHorizontalAlignment(CENTER);

        GroupLayout layout = new GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 500, GroupLayout.PREFERRED_SIZE)
                .addContainerGap(60, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(msgLabel, GroupLayout.PREFERRED_SIZE, 40, GroupLayout.PREFERRED_SIZE)
                .addContainerGap(20, Short.MAX_VALUE))
        );

        pack();
    }

    public void setMessage(String text) {
        msgLabel.setText(text);
    }


}
