/*
 * @(#)GuiUserInteraction.java	1.4 10/09/13
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.gui;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.tck.bvtool.terminal.CardInsertionObserver;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.CardRemovalObserver;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * GUI implementation
 *
 * @author Mikhail Smirnov
 */
public class GuiUserInteraction implements UserInteraction {

    private static GuiUserInteraction instance = new GuiUserInteraction();

    private GuiUserInteraction() {
    }

    public static GuiUserInteraction getUserInteraction() {
        return instance;
    }

    @Override
    public StatefulCardTerminal askForCardInsertion(String terminalLabel, boolean replacement) {
        StatefulCardTerminal retValue = null;
        final InsertCardDialog dialog = new InsertCardDialog(new javax.swing.JFrame(), true);

        dialog.setTerminalName(terminalLabel);
        dialog.setReplacement(replacement);
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                dialog.setVisible(true);
            }
        });
        CardInsertionObserver observer = new CardInsertionObserver();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            terminal.addCardPresenceObserver(observer);
        }
        while (!observer.isInserted() && !dialog.isIdentificationCancelled()) {
            try {
                Thread.sleep(100);
            } catch (InterruptedException ex) {
                //ignore
            }
        }
        dialog.setVisible(false);
        dialog.dispose();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            terminal.removeCardPresenceObserver(observer);
        }
        if (dialog.isIdentificationCancelled()) {
            return null;
        }
        retValue = observer.getSourceTerminal();
        return retValue;
    }


    @Override
    public boolean askForCardReplacement(StatefulCardTerminal terminal) {
        if (terminal.checkCardPresent()) {
            final RemoveCardDialog removalDialog = new RemoveCardDialog(new javax.swing.JFrame(), true);
            removalDialog.setMessage(I18n.getString("remove.card.message", terminal.getLabel()));
            java.awt.EventQueue.invokeLater(new Runnable() {

                public void run() {
                    removalDialog.setVisible(true);
                }
            });
            CardRemovalObserver removalObserver = new CardRemovalObserver();
            terminal.addCardPresenceObserver(removalObserver);
            while (!removalObserver.isRemoved()) {
                try {
                    Thread.sleep(100);
                } catch (InterruptedException ex) {
                    //ignore
                }
            }
            removalDialog.setVisible(false);
            removalDialog.dispose();
            terminal.removeCardPresenceObserver(removalObserver);
        }
        StatefulCardTerminal insertionTerminal = askForCardInsertion(terminal.getLabel(), true);
        if (insertionTerminal == null) {
            return false;
        }
        return true;
    }

    @Override
    /*
     * Shows modal dialog that asks user to enter an ID of the inserted card
     */
    public String showCardIDSelectDialog(String terminalLabel) {
        Set<String> idList = CardStore.getDefaultStore().getCardIDs();
        final KeysInputDialog dialog = new KeysInputDialog(new javax.swing.JFrame(), true, idList);
        dialog.setTerminalName(terminalLabel);
        dialog.setVisible(true);
        String selectedCardID = dialog.getCardID();
        dialog.dispose();
        return selectedCardID;
    }

    @Override
    public boolean askForRetryAfterFailedConnection(String terminalLabel) {
        return ExceptionDialog.showMessage(terminalLabel, I18n.getString("connect.failed"));
    }

    @Override
    public boolean askForCardsRemoval() {
        List<CardRemovalObserver> observers = new ArrayList<CardRemovalObserver>();
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            if (terminal.checkCardPresent()) {
                CardRemovalObserver observer = new CardRemovalObserver();
                terminal.addCardPresenceObserver(observer);
                observers.add(observer);
            }
        }

        final RemoveCardDialog removalDialog = new RemoveCardDialog(new javax.swing.JFrame(), true);
        removalDialog.setMessage(I18n.getString("remove.all.cards.message"));
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                removalDialog.setVisible(true);
            }
        });
        while (true) {
            boolean allRemoved = true;
            for (CardRemovalObserver observer: observers) {
                allRemoved &= observer.isRemoved();
            }
            if (allRemoved) {
                break;
            }
            try {
                Thread.sleep(100);
            } catch (InterruptedException ex) {
                //ignore
            }
        }
        removalDialog.setVisible(false);
        removalDialog.dispose();
        return true;
    }


}
