/*
 * %W% %E%
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.jc.javatest.cmdui;

import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.util.Set;
import javax.smartcardio.CardException;

/*
 * Command-line implementation
 *
 * FIXME: Now this implementation is intended to work only with FakeTerminal
 *
 * @author Mikhail Smirnov
 */
public class CmdUserInteraction implements UserInteraction {

    private static CmdUserInteraction instance = new CmdUserInteraction();

    private CmdUserInteraction() {
    }

    public static CmdUserInteraction getUserInteraction() {
        return instance;
    }

    @Override
    public StatefulCardTerminal askForCardInsertion(String terminalLabel, boolean replacement) {
        System.out.println("Insert a card into terminal " + terminalLabel);
        for (StatefulCardTerminal terminal : CardServicesPool.getAvailableTerminals()) {
            if (terminal.getLabel() == null) {
                try {
                    terminal.waitForCardPresent(0);
                } catch (CardException ex) {
                    return null;
                }
                terminal.setLabel(terminalLabel);
                return terminal;
            }
         }
        return null;
    }

    @Override
    public boolean askForCardReplacement(StatefulCardTerminal terminal) {
        String terminalLabel = terminal.getLabel();
        if (terminal.checkCardPresent()) {
            System.out.println("Remove a card from terminal " + terminalLabel);
        }
        try {
            terminal.waitForCardAbsent(0);
        } catch (CardException ex) {
            return false;
        }
        terminal.setLabel(null);
        StatefulCardTerminal insertionTerminal = askForCardInsertion(terminalLabel, true);
        if (insertionTerminal == null) {
            return false;
        }
        return true;
    }

    @Override
    /*
     * Shows modal dialog that asks user to enter an ID of the inserted card
     */
    public String showCardIDSelectDialog(String terminalLabel) {
        Set<String> idList = CardStore.getDefaultStore().getCardIDs();
        if (idList == null) {
            return "0000";
        }
        return idList.toArray(new String[idList.size()])[0];
    }

    @Override
    public boolean askForRetryAfterFailedConnection(String terminalLabel) {
        System.out.println("Failed to connect to a card in terminal: " + terminalLabel);
        return false;
    }

    @Override
    public boolean askForCardsRemoval() {
        return true;
    }
}
