/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.javatest;

import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javatest.Harness;
import com.sun.javatest.TestRunner;
import java.io.File;
import java.util.Map;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.CardStore.Format;
import com.sun.tck.jc.interview.BVTEnvInterview;

public class JCTCKTestSuite extends TestSuite {

    public JCTCKTestSuite(File root, Map tsInfo, ClassLoader cl) throws Fault {
        super(root, tsInfo, cl);
    }

    @Override
    public void starting(Harness harness) throws Fault {
        CardStore store = CardStore.getDefaultStore();
        File tmpDir = harness.getResultTable().getWorkDirectory().getFile("tmp");
        File stateStore = new File(tmpDir, "card-state-storage");
        stateStore.mkdirs();
        store.setStorageDir(stateStore);
        TestEnvironment env = harness.getEnv();
        if (!CardServicesPool.isObserverRegistered()) {
            harness.addObserver(CardServicesPool.getTestRunObserver());
        }
        try {
            String[] list = env.lookup(BVTEnvInterview.CARD_STORE_FILE);
            StringBuilder val = new StringBuilder();
            String delim = "";
            for (String str : list) {
                val.append(delim).append(str);
                delim = " ";
            }
            store.setFormat(findFormat(env));
            store.setKeyList(val.toString());
            store.init();
        } catch (Exception ex) {
            ex.printStackTrace();
            // TODO
        }
        super.starting(harness);
    }

    private Format findFormat(TestEnvironment env) {
        try {
            String[] list = env.lookup(BVTEnvInterview.CARD_STORE_FORMAT);
            return (list[0].equals(BVTEnvInterview.SHORT_FORMAT) ? Format.SHORT : Format.LONG);
        } catch (Exception e) {
            // TODO
            e.printStackTrace();
            return Format.LONG;
        }
    }

    @Override
    protected TestFinder createTestFinder() throws Fault {
        TestFinder find = null;

        try {
            // this block copied from JCKTestSuite
            // can override JTD in JTT file
            File jtdFile;
            String jtdEntry = (String) (getTestSuiteInfo().get("testsuite.jtd"));
            if (jtdEntry == null || jtdEntry.length() == 0) {// default
                jtdFile = new File(new File(getRootDir(), "tests"), "testsuite.jtd");
            } else {
                File f = new File(jtdEntry);
                if (f.isAbsolute())
                    jtdFile = f;
                else
                    jtdFile = new File(getRootDir(), f.getPath());
            }

            // decide which finder to user here
            if (jtdFile.exists()) {
                BinaryTestFinder btf = new BinaryTestFinder();
                btf.init((new String[] { "-binary", jtdFile.getPath() }),
                            getTestsDir(), null);
                find = btf;
            } else {
                HTMLTestFinder htmltf = new HTMLTestFinder();
                htmltf.init(new String[] {"-dirWalk"},
                            getTestsDir(), null);
                find = htmltf;
            }
        } catch (TestFinder.Fault f) {
            f.printStackTrace();
        }
        return find;
    }

    @Override
    public TestRunner createTestRunner() {
        return QueueTestRunner.createTestRunner();
    }

//     public Script createScript(TestDescription td, String[] exclTestCases,
//                                TestEnvironment scriptEnv,
//                                WorkDirectory workDir,
//                                BackupPolicy backupPolicy) throws Fault {
//         String[] envData;
//         Script s;
//         String[] scriptArgs;

//         Script s = new JCScript();
//         s.initTestDescription(td);
//         s.initExcludedTestCases(exclTestCases);
//         s.initTestEnvironment(scriptEnv);
//         s.initWorkDir(workDir);
//         s.initBackupPolicy(backupPolicy);
//         s.initClassLoader(getClassLoader());
//         return s;
//     }

//     protected Script getScript(){
//         return new TCKScript();
//     }
}
