/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;


import java.util.Map;
import java.util.ArrayList;
import java.util.HashMap;
import java.io.File;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.FileFilter;

public class PathQuestion extends FileListQuestion {
    private String root_dir_name;
    private String root_dir_value;
    private CompositeInterview interview;
    
    public PathQuestion(Interview parent, String tag, FileFilter filter[],
                        Validator validator, Map map,  String root_dir_name) {
        super(parent, tag, validator, map);
        this.setFilters(filter);
        if (root_dir_name != null) {
            this.root_dir_name = root_dir_name;
            this.interview = (CompositeInterview)parent;
            Question root = this.interview.getQuestion(root_dir_name);
            this.root_dir_value = root.getStringValue();
            File baseDir = getExistingFile(this.root_dir_value);
            if (baseDir != null) {
                this.setBaseDirectory(baseDir);
            }
            
            ((InterviewEntry)root).addListener(new ValueSetListener() {
                    public void valueSet(String newValue) {
                        update(newValue);
                    }
                });
        }
    }

    private static File getExistingFile(String value) {
        File retVal = null;
        return ((value != null) && ((retVal = new File(value)).exists())
                ? retVal : null);
    }
    
    public PathQuestion(Interview parent, String tag, FileFilter filter[],
                        Validator validator, Map map) {
        this(parent, tag, filter, validator, map, null);
    }
    
    public PathQuestion(Interview parent, String tag, FileFilter filter[],
                        Validator validator) {
        this(parent, tag, filter, validator, null, null);
    }
    
    public void update(String new_value) {
        if ((root_dir_name != null) && !isEmpty(new_value)) {
            String value = getStringValue();
            this.root_dir_value =  new_value;
            setValue(value);
        } else {
            this.root_dir_value =  new_value;
        }
        File baseDir = getExistingFile(new_value);
        if (baseDir != null) {
            this.setBaseDirectory(baseDir);
        }
    }
    
    public String getStringValue() {
        File[] list = getValue();
        File root = (this.root_dir_value == null) ? null
                    : new File(this.root_dir_value);
        String strValue = "";
        if ((list != null) && (list.length > 0)) {
            StringBuffer data = new StringBuffer(convertToPath(list[0].getPath()));
            for (int i = 1 ; i < list.length; i++) {
                data.append("$:");
                data.append(convertToPath((list[i].isAbsolute() && (root != null))
                                          ? list[i].getPath()
                                          : (new File(root, list[i].getPath())).getPath()));
            }
            strValue = data.toString();
        }
        return strValue;
    }

    public static boolean isEmpty(String str) {
        return ((str == null) || str.equals(""));
    }
    
    public String convertFromPath(String path) {
        String prefix = "$" + this.root_dir_name;
        return ((path.startsWith(prefix)
                 && !isEmpty(this.root_dir_value))
                ? (this.root_dir_value + addSeparator(path.substring(prefix.length())))
                : path);
    }
    
    public String convertToPath(String path) {
        return ((!isEmpty(root_dir_value) && path.startsWith(root_dir_value))
                ? ("$" + root_dir_name + addSeparator(path.substring(root_dir_value.length())))
                : path);
    }

    public static String addSeparator(String path) {
        return ((path.startsWith("$/") || path.startsWith(File.separator))
                ? path : (File.separator + path));
    }
    
    public void setValue(String value) {
        if (value == null) {
            super.setValue(value);
            return;
        }
        ArrayList list = splitPath(value);
        for (int i = 0; i < list.size(); i++) {
            list.set(i, new File(convertFromPath((String)list.get(i))));
        }
        setValue((File[])list.toArray(new File[list.size()]));
    }

    public static ArrayList splitPath(String paths) {
        String delim = "$:";
        ArrayList list = new ArrayList();
        int offset = 0;
        int pos = 0;
        int step = delim.length();
        while ((pos = paths.indexOf(delim, offset)) >= 0) {
            addIfNonNull(list, paths.substring(offset, pos));
            offset = pos + step;
        }
        addIfNonNull(list, paths.substring(offset));
        return list;
    }
    
    private static void addIfNonNull(ArrayList list, String value) {
        if ((value != null) && !value.equals("")) {
            list.add(value);
        }
    }
                 
    
    public static final FileFilter allFilters[] = new FileFilter[] {
        new FileFilter () {
           public boolean accept(File f) {
               String name = f.getName().toLowerCase();
               return (name.endsWith(".jar") || name.endsWith(".zip"));
            }
            
            public boolean acceptsDirectories() {
                return false;
            }
            
            public String getDescription() {
                return "jar and zip files";
            }
        },
        new FileFilter () {
            public boolean accept(File f) {
                return true;
            }
            public boolean acceptsDirectories() {
                return true;
            }
            public String getDescription() {
                return "All";
            }
        }
    };
}
