/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.util.Map;
import java.util.HashMap;

import com.sun.interview.Interview;
import com.sun.interview.Question;

public class NullQuestion extends com.sun.interview.NullQuestion
    implements InterviewEntry {
    private InterviewPathResolver resolver;
    private Validator validator;
    private Map map;
    private Object defaultValue;
    
    public NullQuestion(Interview interview, String tag) {
        super(interview, tag);
    }
    
    public void setResolver(InterviewPathResolver resolver) {
        this.resolver = (resolver == null) ? InterviewPathResolver.Null : resolver;
    }

    public void setValidator(Validator validator) {
        this.validator = (validator == null) ? Validator.TrueValidator : validator;
    }

    public Question getNext() {
        return (validator.accept(this.tag, null, map)
                ? resolver.getNext(this.tag) : null);
    }

    public void addListener(ValueSetListener listener) {
    }

    public void setDefaultValue(String value) {
    }
    
    public void setKey(String key) {
    }
}
