/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import com.sun.interview.Question;
import com.sun.interview.Interview.Fault;

public interface InterviewPathResolver {
    public static class NoEntry extends RuntimeException {
        public NoEntry(String message) {
            super(message);
        }
    }

    public Question getQuestion(String tag) throws NoEntry;
    
    public Question getNext(String tag) throws NoEntry;

    public void update(String tag) throws Fault;

    public void updateFrom(String tag) throws Fault;
    
    public static final InterviewPathResolver Null = new InterviewPathResolver() {
            public String toString() {
                return "com.sun.tck.jc.interview.lib.Null";
            }
            
            public Question getQuestion(String tag) {
                return null;
            }
            
            public Question getNext(String tag) {
                return null;
            }

            public void update(String tag) {
            }

            public void updateFrom(String tag) {
            }

        };
}
