/**
 * @(#)CompositeInterview.java	1.4 03/10/12
 * @Copyright
 */

package com.sun.tck.jc.interview.lib;

import java.io.File;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview.Fault;
import com.sun.javacard.cjck.I18n;
import com.sun.tck.jc.interview.lib.InterviewPathResolver.NoEntry;

public class CompositeInterview extends Interview
    implements InterviewPathResolver {
    private ArrayList list = new ArrayList();
    private HashMap questions = new HashMap();
    private final Question endQuestion = new FinalQuestion(this);
    protected HashMap values = new HashMap();
    
    public CompositeInterview(Interview parent, String tag) {
        super(parent, tag);
    }

    public CompositeInterview(String tag) {
        super(tag);
    }
    
    public void addQuestion(Question next) throws IllegalArgumentException {
        this.addQuestion(next, null, null, false);
    }

    public void addQuestion(Question next, String key)
        throws IllegalArgumentException {
        this.addQuestion(next, key, null, false);
    }

    public void addQuestion(Question next, String key, String defaultValue)
        throws IllegalArgumentException {
        this.addQuestion(next, key, defaultValue, (defaultValue != null));
    }
    
    private void addQuestion(Question next, String key, String value,
                             boolean hasDefault) throws IllegalArgumentException {
        
        if ((next == null) || (!(next instanceof InterviewEntry))) {
            throw new IllegalArgumentException(I18n.getString("question.nonnull"));
        }
        ((InterviewEntry)next).setKey(key);
        if (hasDefault) {
            putValue(next.getTag(), value);
            ((InterviewEntry)next).setDefaultValue(value);
            next.clear();
        }
        questions.put(next.getTag(), new Integer(list.size()));
        list.add(next);
        ((InterviewEntry)next).setResolver(this);
        if (list.size() == 1) {
            setFirstQuestion(next);
        }
    }

    public Question getQuestion(String tag) {
        Integer pos = (Integer)questions.get(tag);
        if ((pos == null)
            && ((pos = (Integer)questions.get(createTag(tag))) == null)) {
            throw new NoEntry("No " + tag);
        }
        return (Question)list.get(pos.intValue());
    }
     
    public Question getNext(String tag) {
        Integer pos = (Integer)questions.get(tag);
        if (pos == null) {
            throw new NoEntry("No " + tag);
        }
        for (int i = pos.intValue() + 1; i < list.size(); i++) {
            Question current = (Question)list.get(i);
            if (isApplicable(current)) {
//                System.out.println("CompositeInterview.getNext(" + tag + ") => '"
//                                   + current.getTag() + "'");
                return current;
            }
        }
        return endQuestion;
    }

    public void update(String tag) throws Fault {
        Integer pos = (Integer)questions.get(createTag(tag));
        if (pos != null) {
            update(pos.intValue());
        }
    }

    public void updateFrom(String tag) throws Fault {
        Integer pos = (Integer)questions.get(createTag(tag));
        Fault ex = null;
        if (pos != null) {
            for (int i = pos.intValue() + 1; i < list.size(); i++) {
                try {
                    update(i);
                } catch (Fault e) {
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public String getValue(String name) {
        Object retVal = values.get(name);
//        System.out.println("getValue("+name+") tries '"+retVal+"'");
        if (retVal == null) {
            retVal = values.get(createTag(name));
//            System.out.println("getValue("+createTag(name)+") returns '"+retVal+"'");
            if (retVal == null) {
                return null;
            } else if (retVal instanceof File) {
                return ((File)retVal).getPath();
            } else {
                return retVal.toString();
            }
        } else {
            return null;
        }
//        return (String)((retVal == null) ? values.get(createTag(name)) : retVal);
    }

    public void putValue(String name, String value) {
        values.put(createTag(name), value);
    }
    
    public String createTag(String shortName) {
        return getTag() + "." + shortName;
    }

    public boolean isApplicable(Question question) {
        return true;
    }
    
    private void update(int pos) throws Fault {
        // Is it required to throw some kind of the Exception if
        // the map does not contain value or value is not String
        // type?
        Question current = (Question)list.get(pos);
        Object val = values.get(current.getTag());
        if ((val != null) && (val instanceof String)) {
            current.setValue((String)val);
        } else {
            current.clear();
        }
    }

    public static Validator or(final Validator first, final Validator second) {
        return new Validator() {
                public String toString() {
                    return "or(" + first + ", " + second + ")";
                }
            
                public boolean accept(String tag, Object o, Map map) {
                    return first.accept(tag, o, map) || second.accept(tag, o, map);
                }

                public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                    return ((first.getErrorQuestion(tag, o, map) == null) ? null
                            : second.getErrorQuestion(tag, o, map));
                }
            };
    }
    
    public static Validator and(final Validator first, final Validator second) {
        return new Validator() {
                public String toString() {
                    return "and(" + first + ", " + second + ")";
                }
            
                public boolean accept(String tag, Object o, Map map) {
                    return first.accept(tag, o, map) && second.accept(tag, o, map);
                }
        
                public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                    return ((first.getErrorQuestion(tag, o, map) != null)
                            ? first.getErrorQuestion(tag, o, map)
                            : second.getErrorQuestion(tag, o, map));
                }
            };
    }
    
    public static Validator not(final Validator first) {
        return new Validator() {
                public String toString() {
                    return "not(" + first + ")";
                }
            
                public boolean accept(String tag, Object o, Map map) {
                    return !first.accept(tag, o, map);
                }

                public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                    return null;
                }
            };
    }
}
