/**
 * %W% %E%
 * @Copyright
 */

package com.sun.tck.jc.interview;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;


import com.sun.interview.ChoiceQuestion;
import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.StringQuestion;
import com.sun.interview.WizPrint;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.CompositeFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.JavaTestError;
import com.sun.javatest.Keywords;
import com.sun.javatest.KeywordsFilter;
import com.sun.javatest.Parameters.MutableExcludeListParameters;
import com.sun.javatest.Parameters.MutablePriorStatusParameters;
import com.sun.javatest.Parameters.MutableTestsParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.interview.BasicInterviewParameters;
import com.sun.javatest.interview.KeywordsInterview;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.lib.Expr;
import com.sun.javatest.TestDescription;

public class JCTCKEnvParameters extends BasicInterviewParameters 
    implements com.sun.javatest.Parameters.EnvParameters {

//    private JCTCKEnvInterview envInterview;
    private BVTEnvInterview envInterview;

    public JCTCKEnvParameters() throws Interview.Fault {
        super("jctck");
        setHelpSet("help/jctck");
        setResourceBundle("i18n");
//        envInterview = new JCTCKEnvInterview(this, "JCTCKEnvInterview");
        envInterview = new BVTEnvInterview(this, "JCTCKEnvInterview");
        clear();
//        setFirstQuestion(configNameQuestion);
    }

    public void setTestSuite(TestSuite suite) {
        super.setTestSuite(suite);
        if (suite != null) {
            envInterview.setRoot(suite.getPath());
            clearExcludeList();
        }
    }

    public String getName() {
        return envInterview.getName();
    }

    void setName(String name) {
        envInterview.setName(name);
    }

    private String cachedEnvName;
    private TestEnvironment cachedEnv;
    private File cachedFile;
    private Map cachedMap;

    public void export(Map map) {
        super.export(map);
        envInterview.export(map);
    }
    
    public TestEnvironment getEnv() {
        Map envMap = new HashMap();
        export(envMap);

        // cache work
        String envName = getName();
        File f = getFile();

        if (equal(envName, cachedEnvName) &&
            equal(f, cachedFile)  &&
            envMap.equals(cachedMap)) {
            return cachedEnv;
        }
	
        cachedEnvName = envName;
        cachedMap = envMap;
        cachedFile = f;

        try {
            String name = getName();
            if (name == null || name.length() == 0 && getResourceBundle() != null)
                // need to wait for a nicer way to get the I18N string
                // coming in JT 3.1.1+ API
                name = "test"; //getResourceBundle().getString("main.error.noName");

            // user sees this value, so we need to internationalize it 
            String desc = "descr test ";//getResourceBundle().getString("main.interview.name");

            cachedEnv = new TestEnvironment(name, envMap, desc);
            return cachedEnv;
        }
        catch (TestEnvironment.Fault e) {
            throw new Error("Unexpected problem creating the CLDC TCK environment");
        }
    }
    // Convenient static methods
    private static boolean equal(Object f1, Object f2) {
        return (f1 == null ? f2 == null : f1.equals(f2));
    }

//     JCTCKParameters getRootInterview() {
//         return parent;
//     }
    private WrapperFilter filter = new WrapperFilter(null);
// #####################################################################
// #####################################################################
    public TestFilter[] getFilters() {
        // this code is directly from MIDP 2.0 interview
        int localFilters = 1;
        String kwExpr = getFilterKeywords();
//        System.out.println("getFilterKeywords() => '" + kwExpr + "'");
        KeywordsFilter kwFilter = null;

        if (kwExpr != null && kwExpr.length() > 0) {
            try {
                kwFilter = new KeywordsFilter(Keywords.create(Keywords.EXPR, kwExpr));
            }	// try
            catch (Keywords.Fault f) {
                kwFilter = null;
            }	// catch
            
            localFilters++;
        }

        TestFilter[] superFilters = super.getFilters();
        TestFilter[] tfs;
        tfs = new TestFilter[superFilters.length + localFilters];

        System.arraycopy(superFilters, 0, tfs, 0, superFilters.length);
        if (kwFilter != null) {
            tfs[tfs.length - 2] = kwFilter;
        }
        tfs[tfs.length - 1] = new SelecIfFilter(cachedEnv);
        return tfs;
    }

    private I18NResourceBundle i18nBundle;
    
    private I18NResourceBundle i18n() {
        if (i18nBundle == null) {
            i18nBundle = I18NResourceBundle.getBundleForClass(getClass());
        }
        return i18nBundle;
    }

    public TestFilter getRelevantTestFilter() {
        TestFilter testfilter = getTestSuite().createTestFilter(getEnv());
        TestFilter testfilter1 = getExcludeTableFilter();
        Vector vector = new Vector(2);
        if (testfilter != null)
            vector.add(testfilter);
        if (testfilter1 != null)
             vector.add(testfilter1);
        TestFilter atestfilter[] = new TestFilter[vector.size()];
        vector.copyInto(atestfilter);
        CompositeFilter compositefilter = new CompositeFilter(atestfilter, i18n(), "params.rFilter");
        return compositefilter;
    }

    /**
     * Utility method to determine the keyword filter for the current
     * settings.
     */
    private String getFilterKeywords() {
        String subsetMode = envInterview.getProduct();
        if (subsetMode == null) {
            return "";
        } else if (subsetMode.equals(JCTCKEnvInterview.Convert)) {
            return "convert";
        } else if (subsetMode.equals(JCTCKEnvInterview.Install)) {
            return "runtime";
        } else if (subsetMode.equals(JCTCKEnvInterview.LoadCap)) {
            return "runtime & !installer";
        } else if (subsetMode.equals(JCTCKEnvInterview.LoadClass)) {
            return "convert & runtime & !installer";
        } else {
            return "";
        }
    }

    //----------------------------------------------------------------------------

    protected Question getPrologSuccessorQuestion() {
        return getEnvFirstQuestion();
    }

    public com.sun.javatest.Parameters.EnvParameters getEnvParameters() {
        return this;
    }

    protected Question getEnvFirstQuestion() {
        return callInterview(envInterview, parametersQuestion);
    }


    //----------------------------------------------------------------------------
    // skip the keywords question
    
    protected Question getKeywordsFirstQuestion() {
        return getKeywordsSuccessorQuestion();
    }

    //----------------------------------------------------------------------------

    public Parameters.KeywordsParameters getKeywordsParameters() {
        // all keyword filtering done in getFilters()
        return null;
    }

    // override so we can set the standard value settings
    public void clear() {
        super.clear();

        if (getPriorStatusParameters() instanceof
            MutablePriorStatusParameters) {
            MutablePriorStatusParameters mpsp =
                (MutablePriorStatusParameters)getPriorStatusParameters();
            mpsp.setPriorStatusMode(MutablePriorStatusParameters.NO_PRIOR_STATUS);
        }

        if (getTestsParameters() instanceof MutableTestsParameters) {
            MutableTestsParameters mtp =
                (MutableTestsParameters)getTestsParameters();
            mtp.setTestsMode(MutableTestsParameters.ALL_TESTS);
        }

        clearExcludeList();
    }

    private void clearExcludeList() {
 
        // make the initial exclude list default, IF it is available
        // unfortunately we can't as the parameter's object itself (see bug
        TestSuite ts;
        if ((getExcludeListParameters() instanceof MutableExcludeListParameters)
            && ((ts = getTestSuite()) != null)) {
            MutableExcludeListParameters melp =
                (MutableExcludeListParameters)getExcludeListParameters();

            if (ts.getInitialExcludeList() != null) {
                melp.setExcludeMode(MutableExcludeListParameters.INITIAL_EXCLUDE_LIST);
            } else {
                // preanswer the question to 'no' if this testsuite has no initial
                // exclude list specified
                // remove this line to force the user to answer the question
                melp.setExcludeMode(MutableExcludeListParameters.NO_EXCLUDE_LIST);
            }
        }
    }

    // this is just here to provide a transition question when going on
    // to the standard values
    private Question parametersQuestion = new NullQuestion(this, "stdvals") {
            protected Question getNext() {
                Question retVal = getEnvSuccessorQuestion();
                return retVal;
           }
        };
}

class SelecIfFilter extends TestFilter {
    private TestEnvironment env;

    public SelecIfFilter(TestEnvironment env) {
        if (env == null) {
            System.out.println("WARNING:: 'null' TestEnvironment in 'SelecIfFilter'");
        }
        this.env = env;
    }
    
    public boolean isSelected(TestDescription td, TestEnvironment env) {
        try {
            String s = td.getParameter("selectIf");
            if ((s == null) || (s.length() == 0) || (env == null)) {
                return true;
            }
            Expr e = Expr.parse(s);
            return e.evalBoolean(env);
        } catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
    }
    
    public boolean accepts(TestDescription td) {
        return this.isSelected(td, this.env);
    }
    
    public boolean accepts(TestDescription td, TestFilter.Observer o) {
        boolean retVal = this.isSelected(td, this.env);
        if (!retVal) {
            o.rejected(td, this);
        }
        return retVal;
    }
    
    public String getDescription() {
        return "The filter evaluates 'selectIf' section in TestDescription "
            + "against to execution environment";
    }
    
    public String getName() {
        return "'selectIf' TestFilter";
    }
    
    public String getReason() {
        return "";
    }
}

class WrapperFilter extends TestFilter {
    private TestFilter filter;
    
    public WrapperFilter(TestFilter filter) {
        this.filter = filter;
    }

    public TestFilter getFilter() {
        return this.filter;
    }
    
    public void setFilter(TestFilter filter) {
        this.filter = filter;
    }
    
    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        return this.filter.accepts(td);
    }
    
    public boolean accepts(TestDescription td, TestFilter.Observer o)
        throws TestFilter.Fault {
        return this.filter.accepts(td, o);
    }
    
    public String getDescription() {
        return this.filter.getDescription();
    }
    
    public String getName() {
        return this.filter.getName();
    }
    
    public String getReason() {
        return this.filter.getReason();
    }

    public boolean equals(Object o) {
        return (filter != null) && filter.equals(o);
    }

    public int hashCode() {
        return (filter == null) ? super.hashCode() : filter.hashCode();
    }
}
