/*
 * %W% %E%
 * 
 * Copyright 2002 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;
import java.io.File;
import java.util.Vector;
import java.util.Map;
import java.net.URL;
import java.net.URLClassLoader;

import com.sun.javatest.Harness;
import com.sun.javatest.Script;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.Parameters;  
import com.sun.javatest.TestFinderQueue;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.PathClassLoader;
import com.sun.jck.lib.JCKScript;

import javasoft.sqe.jc_tck_internal.DistrHTMLTestFinder;
import javasoft.sqe.jc_tck_internal.DistrPrecompileScript;

public class PrecompileTestSuite extends TestSuite {

    public PrecompileTestSuite(File root, Map tsInfo, ClassLoader cl) throws Fault {
        super(root, tsInfo, cl);
    }
  
    protected TestFinder createTestFinder() throws Fault {
        try {
            DistrHTMLTestFinder htmltf = new DistrHTMLTestFinder();
            htmltf.init(new String[] {"-dirWalk"},
                        getTestsDir(), null);
            return htmltf;
        } catch (TestFinder.Fault f) {
            f.printStackTrace();
            return null;
        }
    }
    

    public Script createScript(TestDescription td, String[] exclTestCases,
                               TestEnvironment scriptEnv, 
                               WorkDirectory workDir,
                               BackupPolicy backupPolicy) throws Fault {
        String[] script;
        try {
            script = scriptEnv.lookup("script");
        } catch (TestEnvironment.Fault e) {
            throw new Fault(i18n, "ts.cantFindNameInEnv", e.getMessage());
        }

        Script s;
        if (script.length > 0) {
            Class scriptClass = loadClass(script[0]);
            if (!Script.class.isAssignableFrom(scriptClass)) {
                throw new Fault(i18n, "ts.notASubtype", script[0]);
            }
            String[] scriptArgs = new String[script.length - 1];
            System.arraycopy(script, 1, scriptArgs, 0, scriptArgs.length);

            s = (Script)(newInstance(scriptClass));
            s.initArgs(scriptArgs);
        } else {
            JCKScript js = getScript();
            js.setProduct(js.RUNTIME);
            js.setMode(js.CERTIFY);
            js.initArgs(null);
            s = js;
        }
        s.initTestDescription(td);
        s.initExcludedTestCases(exclTestCases);
        s.initTestEnvironment(scriptEnv);
        s.initWorkDir(workDir);
        s.initBackupPolicy(backupPolicy);
        s.initClassLoader(getClassLoader());
        return s;
    }

    // ------------------- private stuff ------------------

     protected JCKScript getScript(){
         DistrPrecompileScript script = new DistrPrecompileScript();
         script.initArgs(new String[] {"-developer", "-runtime"});
         return script;
     }

    private static final I18NResourceBundle
    i18n = I18NResourceBundle.getBundleForClass(PrecompileTestSuite.class);
    
    protected String tckDirectory = null;
    private String agentClass = null;
    private String[] agentArgs = null;
    private String clientJar = null;
    private String agentJar = null;
    private String resourcePath = null;
    private int jarFileSizeLimit = -1;
    private int testsInBundle = 0;
    private String testPath = null;
    protected String jarSourceDir = null;


}
