/*
 * %W% %E%
 * 
 * Copyright 2002 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.io.PrintWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public class MultiPartSource implements Source {
    ArrayList names = new ArrayList();
    HashMap sections = new HashMap();
    Source last;
    Stack stack = new Stack();
    
    public static class SequenceSection implements Source {

        StringBuffer buff = new StringBuffer();

        public void print(Object o) {
            buff.append(o);
        }

        public String toString() {
            return buff.toString();
        }
    }

    /**
     * creates instance with given names. The constructor creates
     * <code>SequenceSection</code> instances for names. The default part is unset.
     */
    public MultiPartSource(String[] names) {
        if (names != null) {
            for (int i = 0; i < names.length;
                 addPart(names[i++], new SequenceSection()));
        }
    }

    /**
     * add part to the end of Source. The default part is unchanged.
     */
    public void addPart(String name, Source section) {
        name = name.intern();
        this.names.add(name);
        sections.put(name, section);
    }

    public void write(PrintWriter out) throws IOException {
        for (Iterator e = this.names.iterator(); e.hasNext();
             out.print(this.sections.get(e.next()).toString()));
    }

    /**
     * print object to the specified part. The method does not change default part.
     */
    public void print(String name, Object o) {
        ((Source)this.sections.get(name)).print(o);
    }

    /**
     * print given object to the default section.
     * @throws NullPointerException if default part is not set.
     */
    public void print(Object o) {
        last.print(o);
    }

    /**
     * set <code>Source</code> with the given name as defaulte. The
     * previous section is put on the Stack and can be restored by
     * <code>restore()</code> method.
     * @param name given name.
     * @throws IllegalArgumentException if section with the given name
     * does not exist. The nmethod does not change state inthis case.
     */
    public void set(String name) throws IllegalArgumentException {
        Source s = (Source)this.sections.get(name);
        if (s == null) {
            throw new IllegalArgumentException("The section with name '" + name
                                               + "' doesnot exist.");
        }
        stack.push(last);
        last = s;
    }

    /**
     * restore default part, which was stored via <code>set</code> method.
     * @throws java.util.EmptyStackException if there is no stored part.
     */
    public void restore() {
        last = (Source)stack.pop();
    }
}
