/*
 * %W% %E%
 * 
 * Copyright 2003 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.io.File;
import java.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;
import com.sun.tgxml.tools.testgen.processors.emitter.ExternalEmitter;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.TestCase;
import com.sun.tgxml.util.IR;

public class JCExternalEmitter extends ExternalEmitter {
    public static final String
    COPYRIGHT_SHORT_NAME = BuildProperties.getString("copyright.name.short");
    public static final String TESTGEN_COPYRIGHT_LINK_PROP = "copyrightLink";

    protected String output_Dir;
    protected String group_name;
    protected String[] copyright_lines;
    
    protected String createOutputDir(TestGroup tg) throws TestFileException {
        String output_Dir = IR.getAttrElem(Constants.OUTPUT_DIR, tg);
        File f = null;
        if ((output_Dir == null)
            || !((f = new File(output_Dir)).isDirectory() || f.mkdirs())) {
            throw new TestFileException("Can not create " + output_Dir);
        }
        return output_Dir;
    }

    protected ArrayList getTestSources(CodeSet tgAttr)
        throws TestFileException {
        if (tgAttr == null) {
            return new ArrayList();
        }
        ArrayList retVal = BandI.getExternalSourcesNameList(tgAttr, new BandI.SingleFilter() {
                public boolean accept(Object o) {
                    return !Constants.JAVA.equals(o) && !"example".equals(o);
                }
            });
        return retVal;
    }

    protected ArrayList getClientTestSources(CodeSet tgAttr)
        throws TestFileException {
        if (tgAttr == null) {
            return new ArrayList();
        }
        ArrayList retVal = BandI.getExternalSourcesNameList(tgAttr, new BandI.SingleFilter() {
                public boolean accept(Object o) {
                    return Constants.JAVA.equals(o);
                }
            });
        return retVal;
    }

    public static void addIfNotNull(ArrayList data, Object value) {
        if (value != null) {
            if (value instanceof String[]) {
                String[] s = (String[])value;
                for (int i = 0; i < s.length; data.add(s[i++]));
            } else {
                data.add(value);
            }
        }
    }
    
    /**
     * Constructs TestDescriptionIR by: id, title, tgAttr, CodeSet.
     */
    protected TestDescriptionIR constructTestDescriptionIR(
        String id, String title,
        TestGroupAttributes tgAttr, CodeSet codeSet,
        TestCase tc, String context, String executeArgs)
        throws TestFileException {
        TestDescriptionIR retVal = super.constructTestDescriptionIR(id, title, tgAttr, codeSet, tc, context, executeArgs);

        retVal.set(TestDescriptionIR.SOURCE, (String)null);
        retVal.set(Constants.CLIENT_SOURCE, (String)null);
        
        retVal.addRef(TestDescriptionIR.SOURCE, this.getTestSources(codeSet));
        retVal.addRef(Constants.CLIENT_SOURCE, this.getClientTestSources(codeSet));
        return retVal;
    }

    protected Properties props;
    
    public void setProperties(Properties props){
        this.props = props;
        super.setProperties(props);
    }

    protected static Properties addCopyrightLink(Properties props, TestGroup tg) {
        
        String outDir = IR.getAttrElem("OutputDir", tg);
        if (outDir != null) {
            boolean isPath = false;
            int count = 0;
            for (Enumeration e = new StringTokenizer(outDir, "/");
                 e.hasMoreElements();) {
                String entry = (String)e.nextElement();
                if (entry.equals("tests")) {
                    count = 0;
                    isPath = true;
                }
                if (isPath) {
                    count++;
                }
            }
            StringBuffer retVal = new StringBuffer();
            for (int i = 0; i < count; i++) {
                retVal.append("../");
            }
            retVal.append(COPYRIGHT_SHORT_NAME);
            props.setProperty(TESTGEN_COPYRIGHT_LINK_PROP, retVal.toString());
        }
        return props;
    }
}
