/*
 * %W% %E%
 * 
 * Copyright 2010 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.*;
import java.util.HashSet;
import javax.tools.JavaCompiler;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreeScanner;
import com.sun.source.util.Trees;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/**
 *
 * @author ms106086
 */
public class ExceptionToStatusGenerator {
    private static HashSet<String> classesSet = createClassesSet();

    public static boolean processJava(File from, StringWriter out) throws IOException {
        String source = readTextFile(from);
        boolean retVal = false;
        try {
            File[] sources = new File[] {from};
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);

            JavacTask task = (JavacTask)compiler.getTask(null, fileManager, null, null, null,
                    fileManager.getJavaFileObjectsFromFiles(Arrays.asList(sources)));
            Trees root = Trees.instance(task);
            SourcePositions positions = root.getSourcePositions();

            int pos = 0;
            for (CompilationUnitTree element : task.parse()) {
                RunTestCasesContext context = new RunTestCasesContext(element, positions, classesSet);
                new AdapterInformationExtractorExtractor().scan(element, context);
                // insertionPosition is after the latest test case method
                if (context.startPosition > pos) {
                    retVal = true;
                    out.write(source, pos, context.startPosition - pos);
                    out.write("\n");
                    out.write("        javacard.framework.ISOException outOfMemory = new javacard.framework.ISOException((short)0x9c15);\n");
                    out.write("        try {// Added by DoTestGenerator\n");
                    out.write(source, context.startPosition, context.endPosition - context.startPosition);
                    out.write("\n"
                        + "        } catch (javacard.framework.ISOException isoEx) {\n"
                        + "            throw isoEx;\n"
                        + "        } catch (javacard.framework.SystemException se) {\n"
                        + "            short exceptionReason = se.getReason();\n"
                        + "            if (exceptionReason == javacard.framework.SystemException.NO_RESOURCE) {\n"
                        + "                throw outOfMemory;\n"
                        + "            } else {\n"
                        + "                javacard.framework.ISOException.throwIt((short)((short)0x9c10 | (0x0f & exceptionReason)));\n"
                        + "            }\n"
                        + "        } catch (javacard.security.CryptoException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)((short)0x9c20 | (0x0f & ex.getReason())));\n"
                        + "        } catch (javacard.framework.APDUException ex) {\n"
                        + "            short reason = ex.getReason();\n"
                        + "            reason = (byte)((reason & (short)0x07) | (reason >> 9));\n"
                        + "            javacard.framework.ISOException.throwIt((short)((short)0x9c30 | (0x0f & reason)));\n"
                        + "        } catch (ArithmeticException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf0);\n"
                        + "        } catch (ArrayIndexOutOfBoundsException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf1);\n"
                        + "        } catch (ArrayStoreException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf2);\n"
                        + "        } catch (ClassCastException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf3);\n"
                        + "        } catch (IndexOutOfBoundsException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf4);\n"
                        + "        } catch (NegativeArraySizeException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf5);\n"
                        + "        } catch (NullPointerException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf6);\n"
                        + "        } catch (SecurityException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf7);\n"
                        + "        } catch (RuntimeException ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf8);\n"
                        + "        } catch (Exception ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cf9);\n"
                        + "        } catch (Throwable ex) {\n"
                        + "            javacard.framework.ISOException.throwIt((short)0x9cfa);\n"
                        + "        }\n"
                        + "    ");
                    pos = context.endPosition;
                }
            }
            out.write(source, pos, source.length() - pos);
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        } finally {
            out.flush();
        }
        return retVal;
    }

    public static void main(String[] args) throws IOException {
        for (String name : args) {
            StringWriter out = new StringWriter();
            File file = new File(name);
            if (processJava(file, out)) {
                writeTextFile(file, out.toString());
                System.out.println("Generated MultiTest methods in " + name);
            } else {
                System.out.println("Skipped MultiTest methods generation for "
                        + name);
            }
        }
    }

    private static HashSet<String> createClassesSet() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.add("com.sun.javacard.cjck.userinterface.APDU");
        retVal.add("javacard.framework.APDU");
        return retVal;
    }
    /**
     * Reads a text file and returns its contents as a String.
     * @param file file to be read
     * @return file contents
     */
    public static String readTextFile(File file) throws IOException {
        BufferedReader reader = null;
        IOException e = null;
        char[] buf = null;

        try {
            reader = new BufferedReader(new FileReader(file));
            int len = (int)file.length();
            buf = new char[len];
            int off = 0;
            int n = 0;

            while (off < len && (n = reader.read(buf, off, len - off)) > 0) {
                off += n;
            }
        } catch (IOException ioe) {
            e = ioe;
        } finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (e != null) {
            throw e;
        }
        return new String(buf);
    }

    /**
     * Writes given text into a file.
     *
     * @param file the file to write to
     * @param text the text to be written
     */
    public static void writeTextFile(File file, String text) throws IOException {
        IOException e = null;
        FileWriter writer = null;

        try {
            mkdirs(file.getParentFile());
            writer = new FileWriter(file);
            writer.write(text, 0, text.length());
        } catch (IOException ioe) {
            e = ioe;
        } finally {
            if (writer != null) {
                writer.close();
            }
        }
        if (e != null) {
            throw e;
        }
    }

    public static boolean mkdirs(String dir) {
        return mkdirs(new File(dir));
    }

    /** 
     *   Tries to create directory with path specified by File object
     *
     */
    public static boolean mkdirs(File dir) {
        if (dir.exists()) {
            return dir.isDirectory();
        }
        File f = dir.isAbsolute() ? dir : dir.getAbsoluteFile();
        
        File p = f.getParentFile();
        if (!mkdirs(p)) {
            return false;
        }
        return f.mkdir() || f.isDirectory() ;
    }
}

class RunTestCasesContext {
    public int startPosition = -1;
    public int endPosition = -1;
    public HashMap<String, String> importTable = new HashMap<String, String>();
    public LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
    public boolean hasGetTestCases = false;
    public boolean hasExecuteTestCase = false;
    private SourcePositions positions;
    private CompilationUnitTree tree;
    private ArrayList<String> groupImport = new ArrayList<String>();

    private HashSet<String> classesSet = new HashSet<String>();

    public RunTestCasesContext(CompilationUnitTree tree,
            SourcePositions positions,
            HashSet<String> classesSet) {
        this.positions = positions;
        this.tree = tree;
        this.classesSet = classesSet;
    }

    public void clear() {
        names.clear();
    }
    public void registerImport(String decl) {
        int pos = decl.lastIndexOf('.');
        if (pos > 0) {
            String packName = decl.substring(0, pos);
            String name = decl.substring(pos + 1);
            if (name.equals("*")) {
                this.groupImport.add(packName);
            } else {
                this.importTable.put(name, decl);
            }
        }
    }

    // TODO nested statuses processing
    public String getFullClassName(String name) {
        if (name.indexOf('.') <= 0) {
            String fromImport = importTable.get(name);
            if (fromImport != null) {
                return fromImport;
            }
            for (String decl : groupImport) {
               String tryName = decl + "." + name;
                if (classesSet.contains(tryName)) {
                    return tryName;
                }
            }
        }
        return name;
    }

    public void setProcessMethod(MethodTree tree) {
        startPosition = (int)positions.getStartPosition(this.tree, tree.getBody()) + 1;
        endPosition = (int)positions.getEndPosition(this.tree, tree.getBody());
    }
}

class AdapterInformationExtractorExtractor extends TreeScanner<Void,RunTestCasesContext> {

    @Override
    public Void visitImport(ImportTree tree, RunTestCasesContext context) {
        if (!tree.isStatic()) {
            context.registerImport(tree.getQualifiedIdentifier().toString());
        }
        return null;
    }

    @Override
    public Void visitMethod(MethodTree tree, RunTestCasesContext context) {
        if (isProcessMethod(context, tree)) {
            context.setProcessMethod(tree);
        }
        return null;
    }
    String toString(Object ob) {
        return ob == null ? "" : ob.toString();
    }

    private boolean isProcessMethod(RunTestCasesContext context, MethodTree tree) {
        //context.startMethod(tree);
        String type = toString(tree.getReturnType());
        String name = toString(tree.getName());
        if ("process".equals(name) && type.equals("void")) {
            List<? extends VariableTree> list = tree.getParameters();
            int paramLength = (list == null) ? 0 : list.size();
            if (paramLength == 1) {
                VariableTree param = list.get(0);
                String paramType = toString(param.getType());
                paramType = context.getFullClassName(paramType);
                return paramType.equals("javacard.framework.APDU");
            }
        }
        return false;
    }
}
