/*
 * %W% %E%
 * 
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved. 
 * Use is subject to license terms.
 */

package com.sun.tck.jc.internal;

import java.io.PrintWriter;
import com.sun.javatest.Command;
import com.sun.javatest.Status;

/**
 * EchoCommand simply echoes its arguments to the log stream, and reports success.
 */
public class EchoCommand extends Command {
    /**
     * The method that that does the work of the command.
     * @param args	Words to write the the log stream
     * @param log	A stream to which to report messages and errors
     * @param ref	A stream to which to write reference output
     * @return		Status.passed
     */
    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        for (int i = 0; i < args.length; i++) {
            if (i > 0)
                log.print(' ');
            log.print(args[i]);
        }
        log.println();

        return passed;
    }

    private static final Status passed = Status.passed("");
}
