/*
 * %W% %E%
 * 
 * Copyright 2002 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.util.ArrayList;

import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.code.ExternalSupportClass;
import com.sun.tgxml.tjtf.api.code.SupportClass;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;

public class CustomTestDescription extends TestDescriptionIR {

    public final static String RESOURCE = "resources";
    
    public CustomTestDescription(String id, String title,
                                 TestGroupAttributes tgAttr, CodeSet codeSet,
                                 String resources) throws TestFileException {
        this(id, title, tgAttr, BandI.getExternalSourcesNameList(codeSet, null));
        if (resources != null) {
            add(RESOURCE, resources);
        }
    }
    
    public CustomTestDescription(String id, String title,
                                 TestGroupAttributes tgAttr,
                                 ArrayList sources) throws TestFileException {
        String id_name = getCanonical(id);
        String title_name = getCanonical(title);
        add(TestDescriptionIR.TITLE, id_name + " - " + title_name);
        add(TestDescriptionIR.NAME, id_name);
        add(TestDescriptionIR.CLASS, getCanonical(tgAttr.getExecuteClass()));
        add(TestDescriptionIR.KEYWORDS, tgAttr.getKeywords());
        add(TestDescriptionIR.CONTEXT, getCanonical(tgAttr.getContext()));
        add(TestDescriptionIR.EXECUTE_ARGS, getCanonical(tgAttr.getExecuteArgs()));
        add(TestDescriptionIR.EXECUTE_NATIVE, getCanonical(tgAttr.getExecuteNative()));
        add(TestDescriptionIR.REMOTE, tgAttr.getRemotes());
        add(TestDescriptionIR.RMIC_CLASSES, getCanonical(tgAttr.getRMICClasses()));
        add(TestDescriptionIR.SELECT_IF, tgAttr.getSelectIfs());
        add(TestDescriptionIR.TIMEOUT, getCanonical(tgAttr.getTimeout()));
        if (sources != null) {
            add(TestDescriptionIR.SOURCE, sources);
        }
    }

    public static String getCanonical(String data) {
        if ((data == null) || (data.equals(""))) {
            return data;
        }
        int start;
        int end = data.length();
        for (start = 0; start < end; start++) {
            if (isNotIgnored(data.charAt(start))) {
                break;
            }
        }
        
        if (start >= data.length()) {
            return "";
        }
        
        for (end = (data.length() - 1); end > 0; end--) {
            if (isNotIgnored(data.charAt(end))) {
                break;
            }
        }
               
        return data.substring(start, (end + 1));
    }

    public static boolean isNotIgnored(char c) {
        return ((c != ' ') && (c != '\n') && (c != '\r') && (c != '\t'));
    }
    
}
