/*
 * %W% %E%
 * 
 * Copyright 2002 Sun Microsystems, Inc. 
 * SUN PROPRIETARY/CONFIDENTIAL. All rights reserved.
 * Use is subject to license terms.
 *
 */

package com.sun.tck.jc.internal;

import java.io.*;
import java.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.Properties;

import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.code.LibraryDependency;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;
import com.sun.tgxml.tools.testgen.processors.emitter.ExternalEmitter;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.util.IR;
import com.sun.tgxml.tjtf.api.documentation.Documentation;
import com.sun.tgxml.tjtf.api.documentation.TestGroupDocumentation;
import com.sun.tgxml.tjtf.api.code.ExternalSupportClass;

public class BandI extends ExternalEmitter {

    /**
     * returns list of the ExternalSupportClass, which are accepted by given
     * SourceLang filter, names for given TestGroup.
     * @param tg given TestGroup
     * @param filter given filter. The parameter of filter is SourceLang.
     * If filter is null, then all sources will be accepted.
     * @returns ArrayList of String object ot empty ArrayList if there
     * are no ExternalSupportClass with names in the TestGroup.
     */
    public static ArrayList getExternalSourcesNameList(TestGroup tg,
                                                       SingleFilter filter)
    throws TestFileException {
        return getExternalSourcesNameList(tg.getCodeSet(), filter);
    }

    /**
     * returns executeArgs for given TestGroup or null otherwise.
     */
    public static String getExcuteArgs(TestGroup tg) {
        TestGroupAttributes attrs = tg.getTGAttributes();
        return (attrs == null) ? null : attrs.getExecuteArgs();
    }
    
    public static ArrayList getExternalSourcesNameList(CodeSet set,
                                                       SingleFilter filter)
        throws TestFileException {
        ArrayList list;
        ArrayList retVal = new ArrayList();
        if ((set != null) && ((list = set.getSupportClasses()) != null)) {
            for (Iterator e = list.iterator(); e.hasNext();) {
                Object o = e.next();
                if (o instanceof ExternalSupportClass) {
                    ExternalSupportClass cl = (ExternalSupportClass)o;
                    String name = cl.getSourceName();
                    if ((name != null)
                        && ((filter == null)
                            || filter.accept(cl.getSourceLang()))) {
                        retVal.add(name);
                    }
                }
            }
        }
        return retVal;
    }

    public static String getShortClassName(String name) {
        if (name == null) {
            return "";
        }
        int pos = name.lastIndexOf('.');
        if (pos == name.length() - 1) {
            return "";
        } else if (pos < 0) {
            return name;
        } else {
            return name.substring(pos + 1);
        }
    }
    
    public static String getPackageName(String name) {
        if (name == null) {
            return "";
        }
        int pos = name.lastIndexOf('.');
        if (pos < 0) {
            return "";
        } else {
            return name.substring(0, pos);
        }
    }
    
    public static interface SingleFilter {
        public abstract boolean accept(Object o);
    }
}
