/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.bvtool.terminal;

import java.util.ArrayList;
import java.util.List;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CardTerminals;

/**
 *
 * @author Mikhail Smirnov
 */
public class TestCardTerminals extends CardTerminals {

    private static TestCardTerminals terminals = new TestCardTerminals();
    private List<CardTerminal> terminalsList = new ArrayList<CardTerminal>(4);

    private TestCardTerminals() {
        String concurrency = System.getenv("JC_BVT_CONCURRENCY");
        int count = 4;
        if (concurrency != null) {
            try {
                count = Integer.parseInt(concurrency);
            } catch (Exception e) {
                // Ignore
            }
        }
        for (int i = 1; i <= count; i++) {
            terminalsList.add(new FakeTerminal("FakeTerminal #" + i));
        }
    }

    protected static TestCardTerminals getInstance() {
        return terminals;
    }

    @Override
    public CardTerminal getTerminal(String name) {
        return super.getTerminal(name);
    }

    @Override
    public List<CardTerminal> list() throws CardException {
        return terminalsList;
    }

    @Override
    public List<CardTerminal> list(State state) throws CardException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean waitForChange(long timeout) throws CardException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
