/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.tck.bvtool.terminal;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.ResponseAPDU;

/**
 * @author Mikhail Smirnov
 * Mock implementation of CardTerminal for testing Binary Tool framework without
 * real card terminals
 */
public class FakeTerminal extends CardTerminal {

    private String name;
    private boolean isCardPresent = false;

    public FakeTerminal(String name) {
        super();
        this.name = name;
    }

    @Override
    public Card connect(String protocol) throws CardException {
        return new Card() {

            @Override
            public void beginExclusive() throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

//            @Override
            public ResponseAPDU closeLogicalChannel(byte channel) throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void disconnect(boolean reset) throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void endExclusive() throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public ATR getATR() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public CardChannel getBasicChannel() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public String getProtocol() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public CardChannel openLogicalChannel() throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

//            @Override
            public CardChannel openLogicalChannel(byte channel) throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public byte[] transmitControlCommand(int controlCode, byte[] command) throws CardException {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isCardPresent() throws CardException {
        System.out.println("isCardPresent() called:" + isCardPresent);
        return isCardPresent;
    }

    @Override
    public boolean waitForCardAbsent(long timeout) throws CardException {
        isCardPresent = false;
        System.out.println("waitForCardAbsent() called:" + isCardPresent);
        return true;
    }

    @Override
    public boolean waitForCardPresent(long timeout) throws CardException {
        /*try {
        System.out.println("Waiting for a card to be inserted");
        isCardPresent = true;
        Random r = new Random();
        int waitSeconds = 2 + getWaitingTerminals();
        Thread.sleep(waitSeconds * 1000);
        decreaseWaitingTerminals();
        } catch (InterruptedException ex) {
        //ignore
        }*/
        isCardPresent = true;
        System.out.println("waitForCardPresent() called:" + isCardPresent);
        return true;
    }

    @Override
    public String toString() {
        return "Fake Terminal: " + getName() + "[id: " + hashCode() + "]";
    }
}
