/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class TreeNodeImpl implements TreeNode {
    private Object val;
    private String name;
    private static int count = 0;

    public TreeNodeImpl(String name, Object val) {
        this.name = name;
        this.val = val;
    }

    private LinkedHashMap<String, TreeNode> children = new LinkedHashMap<String, TreeNode>();

    public void add(String name, TreeNode child) {
        String key = (name == null) ? ("undefined-" + count()) : name;
        children.put(key, child);
    }

    public void add(TreeNode child) {
        add(null, child);
    }

    private synchronized int count() {
        return ++count;
    }

    public Map<String, ? extends TreeNode> childNodes() {
        return children;
    }

    protected StringBuffer toStringHeader() {
        return new StringBuffer((name == null) ? String.valueOf(val) : (name + "=" + val));
    }

    public Object value() {
        return val;
    }

    public Object get(String path) {
        return get(this, path);
    }

    public static Object get(TreeNode from, String path) {
        String[] list = path.split("/+");
        TreeNode current = from;
        for (String name : list) {
            if (name.equals("")) {
                continue;
            }
            current = (current == null) ? null : current.childNodes().get(name);
        }
        return (current == null) ? null : current.value();
    }

    @Override
    public String toString() {
        StringBuffer retVal = toStringHeader().append(",\n");
        for (TreeNode child : childNodes().values()) {
            String c = child.toString();
            for (String line : c.split("\n")) {
                retVal.append("    ").append(line).append("\n");
            }
        }
        retVal.append("}");
        return retVal.toString();
    }
}
