/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

import java.util.Collections;
import java.util.Map;
import com.sun.tck.me.utils.Utils;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public interface TreeNode {
    public static class Data implements TreeNode, Encodable {
        private byte[] data;
        private String name;

        public Data(String name, int val) {
            this(name, new byte[] {(byte)val});
        }

        public Data(String name, byte[] data) {
            this(name, data, 0, data.length);
        }

        public Data(String name, byte[] data, int offset, int length) {
            this.name = name;
            this.data = new byte[length];
            System.arraycopy(data, offset, this.data, 0, length);
        }

        public Map<String, ? extends TreeNode> childNodes() {
            return Collections.emptyMap();
        }

        public void encode(TLVBuffer buff) {
            buff.write(data);
        }

        @Override
        public String toString() {
            return ((name != null) ? name + "=" : "") + Utils.canonize(data);
        }

        public Object value() {
            return data;
        }

    }

    public static class Value implements TreeNode {
        private Object val;
        private String name;
        public Value(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        public Map<String, ? extends TreeNode> childNodes() {
            return Collections.emptyMap();
        }

        @Override
        public String toString() {
            return (name == null) ? String.valueOf(val) : (name + "=" + val);
        }

        public Object value() {
            return val;
        }
    }

    public Map<String, ? extends TreeNode> childNodes();
    public Object value();
}
