/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.tlv;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.html.HTMLEditorKit.Parser;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ConstantBundle {
    private Transformation parser = new Transformation();
    private HashMap<Integer, String> map = new HashMap<Integer, String>();

    public static class Transformation {
        private int mask = 0xFF;
        private boolean addRequired = true;

        public int createKey(int constant) {
            return constant & mask;
        }

        public void registerAllVariants(Map<Integer, String> names, int constant, String name) {
            constant = createKey(constant);
            String hex = Integer.toHexString(constant);
            names.put(new Integer(constant), name + "(0x" + hex + ")");
            if (addRequired) {
                int req = constant | 0x80;
//                System.out.println(" 0x" + Integer.toHexString(constant | 0x80) + " -> " + name + "(" + hex + " response-equired" + ")");
                names.put(new Integer(req), name + "(0x" + Integer.toHexString(req) + " response-required-bit" + ")");
            }
        }
    }

    public ConstantBundle() {
        this(true, null);
    }

    public ConstantBundle(boolean addRequired, Class cl) {
        parser.addRequired = addRequired;
        registerConstants(cl);
    }

    public void setAddRequired(boolean addRequired) {
        parser.addRequired = addRequired;
    }

    public String find(int constant) {
        constant = parser.createKey(constant);
        String retVal = map.get(new Integer(constant));
        return (retVal == null) ? Integer.toHexString(constant) : retVal;
    }

    private boolean isNumber(Class type) {
        return ((type.equals(Integer.TYPE) || type.equals(Byte.TYPE)
                || type.equals(Short.TYPE)));
    }

    private void registerConstants(Class cl) {
        if (cl == null) {
            return;
        }
        for (Field f : cl.getFields()) {
            int mod = f.getModifiers();
            Class type = f.getType();
            if (Modifier.isFinal(mod) && Modifier.isStatic(mod) && isNumber(type)) {
                try {
                    register(f.getInt(null), f.getName());
                } catch (Exception e) {
                    // Ignore
                }
            }
        }
    }

    public void register(int constant, String name) {
        parser.registerAllVariants(map, constant, name);
    }
}
