/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.security;

import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class KeyDescr {
    public KeyType type;
    public byte keyId;
    public Cipher cipher;
    public Cipher decipher;
    public Checksum checksum;
    private String password;
    public int blockSize = 8;

    public KeyDescr(KeyType type, int keyId, byte[] password) throws GeneralSecurityException {
        this(type, keyId, password, false);
    }

    public KeyDescr(KeyType type, int keyId, byte[] password, boolean doEncrypt) throws GeneralSecurityException {
        this.type = type;
        this.keyId = (byte)keyId;
        this.cipher = type.createCipher(Cipher.ENCRYPT_MODE, password, doEncrypt);
        this.decipher = type.createCipher(Cipher.DECRYPT_MODE, password, doEncrypt);
        this.checksum = new CryptographicChecksum(this);
        this.password = Utils.canonize(password);
    }

    public int encodeKey() {
        return 0xFF & (keyId << 4 | type.getCode());
    }

    public String toString() {
        return "(type=" + type + " id=" + keyId + " key=" + password + ")";
    }
}
