/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gsm;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class StatusCodes {

    public static enum Type {
        USER, OK, WARNING, EXECUTION_ERROR, CHECKING_ERROR
    }

    public static Type getType(int sw) {
        if (sw == 0x9000) {
            return Type.OK;
        }
        sw = 0xFF00 & sw;
        switch (sw) {
            case 0x6100:
                return Type.OK;
            case 0x6200:
            case 0x6300:
                return Type.WARNING;
            case 0x6400:
            case 0x6500:
            case 0x6600:
                return Type.EXECUTION_ERROR;
            default:
                return ((sw & 0xF000) == 0x6000) ? Type.CHECKING_ERROR : Type.USER;
        }
    }

    public static boolean isError(int sw) {
        Type type = getType(sw);
        return (type == Type.CHECKING_ERROR) || (type == Type.EXECUTION_ERROR);
    }

    public static boolean isOkOrWarning(int sw) {
        Type type = getType(sw);
        return (type == Type.OK) || (type == Type.WARNING);
    }
}
