/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gsm;

import com.sun.tck.bvtool.etsi.data.ResponsePacket;
import com.sun.tck.bvtool.etsi.data.sms.SMSParser;
import com.sun.tck.bvtool.etsi.tlv.ConstantBundle;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode.Data;
import com.sun.tck.bvtool.etsi.tlv.TreeNode.Value;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class ProactiveCommandTLV extends ConstructedTLV {
    private ConstantBundle details = createDetailsBundle();

    public ProactiveCommandTLV() {
        constants.setAddRequired(true);
        setTagInternal(GSMTags.ProactiveSIMcommandTag, null);
    }

    private ConstantBundle createDetailsBundle() {
        ConstantBundle retVal = new ConstantBundle(false, null);
        retVal.register(0x01, "REFRESH");
        retVal.register(0x02, "MORE TIME");
        retVal.register(0x03, "POLL INTERVAL");
        retVal.register(0x04, "POLLING OFF");
        retVal.register(0x05, "SET UP EVENT LIST");
        retVal.register(0x10, "SET UP CALL");
        retVal.register(0x11, "Reserved for GSM/3G (SEND SS)");
        retVal.register(0x12, "Reserved for GSM/3G (SEND USSD)");
        retVal.register(0x13, "SEND SHORT MESSAGE");
        retVal.register(0x14, "SEND DTMF");
        retVal.register(0x15, "LAUNCH BROWSER");
        retVal.register(0x20, "PLAY TONE");
        retVal.register(0x21, "DISPLAY TEXT");
        retVal.register(0x22, "GET INKEY");
        retVal.register(0x23, "GET INPUT");
        retVal.register(0x24, "SELECT ITEM");
        retVal.register(0x25, "SET UP MENU");
        retVal.register(0x26, "PROVIDE LOCAL INFORMATION");
        retVal.register(0x27, "TIMER MANAGEMENT");
        retVal.register(0x28, "SET UP IDLE MODE TEXT");
        retVal.register(0x30, "PERFORM CARD APDU");
        retVal.register(0x31, "POWER ON CARD");
        retVal.register(0x32, "POWER OFF CARD");
        retVal.register(0x33, "GET READER STATUS");
        retVal.register(0x34, "RUN AT COMMAND");
        retVal.register(0x35, "LANGUAGE NOTIFICATION");
        retVal.register(0x40, "OPEN CHANNEL");
        retVal.register(0x41, "CLOSE CHANNEL");
        retVal.register(0x42, "RECEIVE DATA");
        retVal.register(0x43, "SEND DATA");
        retVal.register(0x44, "GET CHANNEL STATUS");
        retVal.register(0x45, "SERVICE SEARCH");
        retVal.register(0x46, "GET SERVICE INFORMATION");
        retVal.register(0x47, "DECLARE SERVICE");
        retVal.register(0x81, "End of the proactive session not applicable");
        return retVal;
    }

    private int itemCount = 0;

    @Override
    public void createChild(long tag, TLVPrototypeFactory processor, TLVBuffer in) throws Exception {
        TLVUtils.readTag(in);
        int length = TLVUtils.readLength(in);
        byte[] data = in.readArray(length);
        String name = null;
        RawTLV retVal = new RawTLV((byte)tag, data);
        retVal.setFactory(processor);
        retVal.setTag((byte)tag, null);
        byte canonical = (byte)(0x7f & tag);
        switch (canonical) {
            case GSMTags.CommandDetailsTag:
                retVal.add("command-number", new Data("command-number", data[0]));
                retVal.add("type-of-command", new Value("type-of-command", details.find(data[1])));
                retVal.add("command-qualifier", new Value("command-qualifier", getCommandQualifier(data[2])));
                name = "command-details";
                break;
            case GSMTags.DeviceIdentityTag:
                retVal.add("source", new Value("source", getDeviceIdentity(data[0])));
                retVal.add("destination", new Value("destination", getDeviceIdentity(data[1])));
                name = "device-identity";
                break;
            case GSMTags.AlphaIdentifierTag:
//                String val = TLVUtils.canonize(data);// new String(data, "UTF-8");
                retVal.add("identifier", new Data("identifier=", data));
                name = "alpha-identifier";
                break;
            case GSMTags.ItemTag:
                retVal = new RawTLV((byte)tag, data);
                name = "item-" + (itemCount++);
                break;
            case GSMTags.SMS_TPDU_Tag:
                SMSParser.initSMS(retVal, data);
                name = "SMS-TPDU";
                break;
            default:
                name = null;
        }
        add(name, retVal);
    }

    public static String getCommandQualifier(int val) {
        switch (val & 0xFF) {
            case 00:
                return "NAA Initialization and Full File Change Notification";
            case 01:
                return "File Change Notification";
            case 02:
                return "NAA Initialization and File Change Notification";
            case 03:
                return  "NAA Initialization";
            case 04:
                return  "UICC Reset";
            case 05:
                return "NAA Application Reset, only applicable for a 3G platform";
            case 06:
                return "NAA Session Reset, only applicable for a 3G platform";
            case 07:
                return "reserver (07)";
            case 0xFF:
                return "reserved (FF)";
            default:
                return "Unknown:" + Integer.toHexString(val & 0xFF);
        }
    }

    public static String getDeviceIdentity(int val) {
        switch (val & 0xFF) {
            case 0x01:
                return "Keypad";
            case 0x02:
                return "Display";
            case 0x03:
                return "Earpiece";
            case 0x10: case 0x11: case 0x12: case 0x13:
            case 0x14: case 0x15: case 0x16: case 0x17:
                return "Additional Card Reader #" + (val & 0xF);
            case 0x21: case 0x22: case 0x23: case 0x24:
            case 0x25: case 0x26: case 0x27:
                return "Channel #" + (val & 0xF);
            case 0x81:
                return "UICC";
            case 0x82:
                return "terminal";
            case 0x83:
                return "network";
            default:
                return "Reserver: 0x" + Integer.toHexString(val & 0xFF);
        }
    }
}
