/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gp;

import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardState;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.bvtool.terminal.CardStore.Format;
import java.io.File;

/**
 *
 * @author ms106086
 */
public class GSMCardConfigurator {
    private String keyList;
    private String KID;
    private String KIC;
    private Integer securityLevel;
    private Integer counter;
    private String iccid;
    private Integer keyVersion;
    private Card card;
    private CardStore store;
    private File stateStorage;
    private int counterStep;
    private CardStore.Format format = Format.LONG;

    public void setKeyListFormat(String name) {
        this.format = "short".equalsIgnoreCase(name) ? Format.SHORT : Format.LONG;
    }

    public void setKIC(String KIC) {
        this.KIC = KIC;
    }

    public void setKID(String KID) {
        this.KID = KID;
    }

    public void setCounter(int counter) {
        this.counter = new Integer(counter);
    }

    public void setKeyList(String keyList) {
        this.keyList = keyList;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = new Integer(securityLevel);
    }

    public void setCounterStep(int step) {
        this.counterStep = step;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public void setKeyVersion(int keyVersion) {
        this.keyVersion = new Integer(keyVersion);
    }

    public void setStorageDir(File dir) {
        dir.mkdirs();
        this.stateStorage = dir;
    }

    public void init() throws Exception {
        if ((keyList != null) && (iccid != null)) {
            store = new CardStore();
            store.setFormat(format);
            store.setStorageDir(stateStorage);
            store.setKeyList(keyList);
            store.init();
            card = store.findCard(iccid);
        } else {
            String id = (iccid == null) ? KID : iccid;
            iccid = (iccid == null) ? id : iccid;
            int key = (keyVersion == null) ? Card.DEFAULT_KEY : keyVersion.intValue();
            card = new Card(CardState.restore(stateStorage, id), iccid, key, KID, KIC);
        }
        if (keyVersion != null) {
            card.setKeyVersion(keyVersion.intValue());
        }
        if (counter != null) {
            card.setCounter(counter.intValue());
        }
        if (securityLevel != null) {
            card.setSecurityLevel(securityLevel.intValue());
        }
        if (counterStep > 0) {
            card.counterStep = counterStep;
        }
    }

    public Card getCard() {
        return card;
    }

    public void close() throws Exception {
        if (store != null) {
            store.close();
        }
    }
}
