/*
 * %W% %E%
 *
 * Copyright 2010, Oracle and/or its affiliates. All rights reserved.
 * Oracle PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.tck.bvtool.etsi.gp;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.tck.bvtool.etsi.gsm.ETSITags;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.me.utils.Closables;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import com.sun.tck.me.utils.Utils;
import java.io.IOException;
import java.io.OutputStreamWriter;

/**
 *
 * @author Maxim V. Sokolnikov
 */
public class GPCapFileInfo {
    public static final byte GET_DATA_CLA = (byte)0x80;
    public static final byte GET_DATA_INS = (byte)0xCA;
    // GET_DATA , GP 2.1.1, page 112
    // CLA '00', '80' or '84'
    // INS 'CA' GET DATA
    // P1 'xx' '00' or high order tag value
    // P2 'xx' Low order tag value
    // Lc 'xx' Not present or length of MAC
    // Data 'xxxx...' MAC if present
    public static final byte INSTALL_CLA = (byte)0x80;
    public static final byte INSTALL_INS = (byte)0xE6;
    public static final byte INSTALL_P1_FOR_LOAD = (byte)0x02;
    public static final byte INSTALL_P1_FOR_INSTALL = (byte)0x04;
    public static final byte INSTALL_P1_FOR_MAKE_SELECTABLE = (byte)0x08;
    private static String[] COMPONENTS_ORDER = new String[] {
        // See JC VM spec, Chapter 6,2 as reference
        "Header.cap",       // COMPONENT_Header
        "Directory.cap",    // COMPONENT_Directory
        "Import.cap",       // COMPONENT_Import
        "Applet.cap",       // COMPONENT_Applet
        "Class.cap",        // COMPONENT_Class
        "Method.cap",       // COMPONENT_Method
        "StaticField.cap",  // COMPONENT_StaticField
        "Export.cap",       // COMPONENT_Export
        "ConstantPool.cap", // COMPONENT_ConstantPool
        "RefLocation.cap",  // COMPONENT_ReferenceLocation
        "Descriptor.cap",   // COMPONENT_Descriptor (optional)
    };
    public RawTLV data;
    public AppletID packageAID;
    public String capFile;

    public GPCapFileInfo(String capFile,byte[] data, AppletID packageAID) {
        this.capFile = capFile;
        this.data = new RawTLV(ETSITags.LOAD_FILE_DATA_BLOCK, data);
        this.packageAID = packageAID;
    }

    public static GPCapFileInfo createData(PrintWriter out, String capFileName) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        File file = new File(capFileName);
        CapFile cap = new CapFile(file);
        AppletID aid = null;
        for (String name : COMPONENTS_ORDER) {
            InputStream in = cap.getComponent(name);
            if (in == null) {
                out.println("Can not find " + name + " in " + capFileName);
                continue;
            }
            Closables cls = new Closables();
            try {
                if (name.equals("Header.cap")) {
                    Utils.copyData(in, data, 10);
                    // start package info
                    Utils.copyData(in, data, 2);

                    byte[] aidBytes = new byte[in.read()];
                    data.write(aidBytes.length);

                    in.read(aidBytes);
                    data.write(aidBytes);

                    aid = new AppletID(aidBytes);
                }
                Utils.copyData(in, data);
            } finally {
                cls.close();
            }
        }
        data.close();
        return new GPCapFileInfo(capFileName, data.toByteArray(), aid);
    }

    @Override
    public String toString() {
        return "(cap-file=" + capFile + " package-aid=" + packageAID + ")";
    }

    public static void main(String[] args) throws Exception {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(System.out));
        for (String arg : args) {
            GPCapFileInfo cap = createData(out, arg);
            System.out.println("file=" + arg + " AID=" + cap.packageAID);
        }
    }
}
